/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.converter.TipoPessoaEnumConverter;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaSituacao;
import br.com.elotech.di.domain.siscop.SiscopBanco;
import br.com.elotech.di.domain.siscop.SiscopCidade;
import br.com.elotech.di.domain.siscop.SiscopFornecedorAlteraRazao;
import br.com.elotech.di.domain.siscop.SiscopFornecedorBanco;
import br.com.elotech.di.domain.siscop.SiscopFornecedorNegativa;
import br.com.elotech.di.domain.siscop.SiscopUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.unico.client.domain.enums.PessoaEscolaridade;
import br.com.elotech.unico.client.domain.enums.PessoaTipoEmpresa;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="siscop.fornecedor")
@DynamicInsert
@DynamicUpdate
public class SiscopFornecedor
implements Replicable<Pessoa, Long>,
Serializable {
    @Id
    @EloSequence
    @Column(name="fornecedor")
    private Long codigo;
    @Length(max=150)
    private @Length(max=150) String nome;
    @Column(name="fantasia")
    @Length(max=150)
    private @Length(max=150) String nomeFantasia;
    @Length(max=250)
    @Column(length=250)
    private @Length(max=250) String endereco;
    @Length(max=50)
    private @Length(max=50) String cidade;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    private SiscopUnidadeFederacao uf;
    @Length(max=10)
    private @Length(max=10) String cep;
    @Length(max=20)
    private @Length(max=20) String fax;
    @Length(max=8)
    private @Length(max=8) String caixapostal;
    @Length(max=15)
    @Column(name="cnpj")
    private @Length(max=15) String cnpjCpf;
    @Length(max=10)
    private @Length(max=10) String agencia;
    @Length(max=25)
    private @Length(max=25) String conta;
    @Column(name="cgcm")
    @Length(max=20)
    private @Length(max=20) String inscricaoMunicipal;
    @Column(name="inscest")
    @Length(max=20)
    private @Length(max=20) String inscestRg;
    @Length(max=60)
    private @Length(max=60) String contato;
    @Length(max=100)
    private @Length(max=100) String homepage;
    @Length(max=100)
    private @Length(max=100) String email;
    @Length(max=60)
    private @Length(max=60) String bairro;
    @Convert(converter=TipoPessoaEnumConverter.class)
    private TipoPessoa tipoPessoa;
    private PessoaSituacao situacao = PessoaSituacao.DEFAULT;
    @Column(name="datavigencia")
    private LocalDate inscMunDataVigencia;
    @Column(name="datarenovacao")
    private LocalDate inscMunDataRenovacao;
    @Length(max=20)
    private @Length(max=20) String orgaoemissor;
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    private LocalDate dataAlteracao;
    @Length(max=1)
    private @Length(max=1) String valido;
    private Integer mescriacao;
    private PessoaTipoEmpresa tipoEmpresa;
    private LocalDate dataCadastro;
    @Length(max=35)
    private @Length(max=35) String contasubvencao;
    @Length(max=20)
    private @Length(max=20) String tel;
    private LocalDate dataaberturaconta;
    @Column(name="inscricaogenerica")
    @Length(max=20)
    private @Length(max=20) String audespGenerica;
    @Length(max=20)
    private @Length(max=20) String pis;
    @Column(name="identificacaoespecial")
    @Length(max=20)
    private @Length(max=20) String audespEspecial;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean consorcio;
    private BigDecimal percentual;
    private PessoaEscolaridade escolaridade;
    private Long idTcePR;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean restricaojudicial;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean responsavelliquidacao;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="micropequena")
    private Boolean microEmpresa;
    @Length(max=1000)
    private @Length(max=1000) String observacaoJudicial;
    @ManyToOne
    private SiscopBanco banco;
    @ManyToOne
    @JoinColumn(name="idCidade")
    private SiscopCidade cidadeObj;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.fornecedor")
    @Valid
    private final List<SiscopFornecedorBanco> bancos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.fornecedor")
    private final List<SiscopFornecedorAlteraRazao> alteracoesRazao = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="fornecedor", updatable=false, nullable=false)
    @Valid
    private final List<SiscopFornecedorNegativa> documentos = new ArrayList();
    private Long idUnico;

    public static SiscopFornecedor ofPessoa(Long siscopPessoa) {
        SiscopFornecedor p = new SiscopFornecedor();
        p.setCodigo(siscopPessoa);
        return p;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public SiscopUnidadeFederacao getUf() {
        return this.uf;
    }

    public SiscopCidade getCidadeObj() {
        return this.cidadeObj;
    }

    public void setCidadeObj(SiscopCidade cidadeObj) {
        this.cidadeObj = cidadeObj;
    }

    public void setUf(SiscopUnidadeFederacao uf) {
        this.uf = uf;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getCaixapostal() {
        return this.caixapostal;
    }

    public void setCaixapostal(String caixapostal) {
        this.caixapostal = caixapostal;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    public void setInscricaoMunicipal(String inscricaoMunicipal) {
        this.inscricaoMunicipal = inscricaoMunicipal;
    }

    public void setInscestRg(String inscestRg) {
        this.inscestRg = inscestRg;
    }

    public String getInscestRg() {
        return this.inscestRg;
    }

    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public PessoaSituacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(PessoaSituacao situacao) {
        this.situacao = situacao;
    }

    public LocalDate getInscMunDataVigencia() {
        return this.inscMunDataVigencia;
    }

    public void setInscMunDataVigencia(LocalDate datavigencia) {
        this.inscMunDataVigencia = datavigencia;
    }

    public LocalDate getInscMunDataRenovacao() {
        return this.inscMunDataRenovacao;
    }

    public void setInscMunDataRenovacao(LocalDate datarenovacao) {
        this.inscMunDataRenovacao = datarenovacao;
    }

    public String getOrgaoemissor() {
        return this.orgaoemissor;
    }

    public void setOrgaoemissor(String orgaoemissor) {
        this.orgaoemissor = orgaoemissor;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public String getValido() {
        return this.valido;
    }

    public void setValido(String valido) {
        this.valido = valido;
    }

    public Integer getMescriacao() {
        return this.mescriacao;
    }

    public void setMescriacao(Integer mescriacao) {
        this.mescriacao = mescriacao;
    }

    public PessoaTipoEmpresa getTipoEmpresa() {
        return this.tipoEmpresa;
    }

    public void setTipoEmpresa(PessoaTipoEmpresa tipoEmpresa) {
        this.tipoEmpresa = tipoEmpresa;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(LocalDate datacadastro) {
        this.dataCadastro = datacadastro;
    }

    public String getContasubvencao() {
        return this.contasubvencao;
    }

    public void setContasubvencao(String contasubvencao) {
        this.contasubvencao = contasubvencao;
    }

    public String getTel() {
        return this.tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public LocalDate getDataaberturaconta() {
        return this.dataaberturaconta;
    }

    public void setDataaberturaconta(LocalDate dataaberturaconta) {
        this.dataaberturaconta = dataaberturaconta;
    }

    public String getAudespGenerica() {
        return this.audespGenerica;
    }

    public void setAudespGenerica(String audespGenerica) {
        this.audespGenerica = audespGenerica;
    }

    public String getPis() {
        return this.pis;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public String getAudespEspecial() {
        return this.audespEspecial;
    }

    public void setAudespEspecial(String audespEspecial) {
        this.audespEspecial = audespEspecial;
    }

    public Boolean getConsorcio() {
        return this.consorcio;
    }

    public void setConsorcio(Boolean consorcio) {
        this.consorcio = consorcio;
    }

    public BigDecimal getPercentual() {
        return this.percentual;
    }

    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    public PessoaEscolaridade getEscolaridade() {
        return this.escolaridade;
    }

    public void setEscolaridade(PessoaEscolaridade escolaridade) {
        this.escolaridade = escolaridade;
    }

    public Long getIdTcePR() {
        return this.idTcePR;
    }

    public void setIdTcePR(Long idtcepr) {
        this.idTcePR = idtcepr;
    }

    public String getObservacaoJudicial() {
        return this.observacaoJudicial;
    }

    public void setObservacaoJudicial(String observacaojudicial) {
        this.observacaoJudicial = observacaojudicial;
    }

    public SiscopBanco getBanco() {
        return this.banco;
    }

    public void setBanco(SiscopBanco banco) {
        this.banco = banco;
    }

    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = microEmpresa;
    }

    public Boolean getResponsavelliquidacao() {
        return this.responsavelliquidacao;
    }

    public void setResponsavelliquidacao(Boolean responsavelliquidacao) {
        this.responsavelliquidacao = responsavelliquidacao;
    }

    public Boolean getRestricaojudicial() {
        return this.restricaojudicial;
    }

    public void setRestricaojudicial(Boolean restricaojudicial) {
        this.restricaojudicial = restricaojudicial;
    }

    public SiscopFornecedor withCodigo(Long codigoSiscop) {
        this.codigo = codigoSiscop;
        return this;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public List<SiscopFornecedorBanco> getBancos() {
        return this.bancos;
    }

    public List<SiscopFornecedorNegativa> getDocumentos() {
        return this.documentos;
    }

    public boolean hasEndereco() {
        return !StringUtils.isBlank((String)this.getCep()) || !StringUtils.isBlank((String)this.getEndereco()) || !StringUtils.isBlank((String)this.getBairro()) || !StringUtils.isBlank((String)this.getCidade()) || this.getCidadeObj() != null;
    }

    public static SiscopFornecedor of(Long codigo) {
        return new SiscopFornecedor().withCodigo(codigo);
    }

    public SiscopFornecedor withIdUnico(Long idunico) {
        this.setIdUnico(idunico);
        return this;
    }

    public List<SiscopFornecedorAlteraRazao> getAlteracoesRazao() {
        return this.alteracoesRazao;
    }

    @Generated
    public String toString() {
        return "SiscopFornecedor(codigo=" + this.getCodigo() + ", nome=" + this.getNome() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiscopFornecedor)) {
            return false;
        }
        SiscopFornecedor other = (SiscopFornecedor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiscopFornecedor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

