/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.PoderOrgaoContabil;
import br.com.elotech.di.domain.siscop.SiscopUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="siscop.entidade")
public class SiscopEntidade
implements EloEntity<Long>,
Replicable<Entidade, Long> {
    @Id
    @Column(name="entidade")
    @NotNull
    @EloSequence
    private Long id;
    @Column(length=100)
    @Length(max=100)
    private @Length(max=100) String nome;
    @Column(length=15)
    @Length(max=15)
    private @Length(max=15) String cnpj;
    @Column(length=100)
    @Length(max=100)
    private @Length(max=100) String logradouro;
    @Column(length=40)
    @Length(max=40)
    private @Length(max=40) String bairro;
    @Column(length=40)
    @Length(max=40)
    private @Length(max=40) String cidade;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    private SiscopUnidadeFederacao uf;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    private SiscopEntidade entidadePrincipal;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String cep;
    @Column(name="tipoEntidade")
    private EntidadeTipo tipo;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String identificacaoTCE;
    private byte[] brasao;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String telefone;
    private Boolean consolida = Boolean.TRUE;
    @Column(name="cod_audesp")
    private Long codAudesp;
    @Column(name="cod_munic_audesp")
    private Long codMunicAudesp;
    @Column(name="clienteelotechsn")
    private Boolean clienteElotech;
    private Long idUnico;
    @Column(name="mscpoderorgao")
    private PoderOrgaoContabil poderOrgaoContabil;
    @Column(name="msccodigosiconfi", length=10)
    private String codigoSiconfi;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public SiscopUnidadeFederacao getUf() {
        return this.uf;
    }

    public void setUf(SiscopUnidadeFederacao uf) {
        this.uf = uf;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public SiscopEntidade getEntidadePrincipal() {
        return this.entidadePrincipal;
    }

    public void setEntidadePrincipal(SiscopEntidade entidadePrincipal) {
        this.entidadePrincipal = entidadePrincipal;
    }

    public EntidadeTipo getTipo() {
        return this.tipo;
    }

    public void setTipo(EntidadeTipo tipo) {
        this.tipo = tipo;
    }

    public String getIdentificacaoTCE() {
        return this.identificacaoTCE;
    }

    public void setIdentificacaoTCE(String identificacaoTCE) {
        this.identificacaoTCE = identificacaoTCE;
    }

    public byte[] getBrasao() {
        return this.brasao;
    }

    public void setBrasao(byte[] brasao) {
        this.brasao = brasao;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public Boolean getConsolida() {
        return this.consolida;
    }

    public void setConsolida(Boolean consolida) {
        this.consolida = consolida;
    }

    public Long getCodAudesp() {
        return this.codAudesp;
    }

    public void setCodAudesp(Long codAudesp) {
        this.codAudesp = codAudesp;
    }

    public Long getCodMunicAudesp() {
        return this.codMunicAudesp;
    }

    public void setCodMunicAudesp(Long codMunicAudesp) {
        this.codMunicAudesp = codMunicAudesp;
    }

    public Boolean getClienteElotech() {
        return this.clienteElotech;
    }

    public void setClienteElotech(Boolean clienteElotech) {
        this.clienteElotech = clienteElotech;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    @Transient
    public boolean isEntidadePrincipal() {
        return this.equals((Object)this.entidadePrincipal);
    }

    public static SiscopEntidade of(Long id) {
        SiscopEntidade entidade = new SiscopEntidade();
        entidade.setId(id);
        return entidade;
    }

    public SiscopEntidade withIdUnico(Long idUnico) {
        this.setIdUnico(idUnico);
        return this;
    }

    public PoderOrgaoContabil getPoderOrgaoContabil() {
        return this.poderOrgaoContabil;
    }

    public void setPoderOrgaoContabil(PoderOrgaoContabil poderOrgaoContabil) {
        this.poderOrgaoContabil = poderOrgaoContabil;
    }

    public String getCodigoSiconfi() {
        return this.codigoSiconfi;
    }

    public void setCodigoSiconfi(String codigoSiconfi) {
        this.codigoSiconfi = codigoSiconfi;
    }

    @Generated
    public String toString() {
        return "SiscopEntidade(id=" + this.getId() + ", nome=" + this.getNome() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiscopEntidade)) {
            return false;
        }
        SiscopEntidade other = (SiscopEntidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiscopEntidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

