/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.siscop.SiscopUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="siscop.cidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class SiscopCidade
implements Replicable<Cidade, Long> {
    public static final SiscopCidade CIDADE_INVALIDA = new SiscopCidade();
    @Id
    @EloSequence
    @Column(name="cidade")
    private Long codigo;
    @ManyToOne
    @NotNull
    private SiscopUnidadeFederacao unidadeFederacao;
    @Size(max=100)
    private @Size(max=100) String descricao;
    @Size(max=10)
    @Column(name="ibge")
    private @Size(max=10) String codigoIbge;
    @Column(name="idmt")
    private Long codigoAplic;
    private Long idUnico;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;

    public SiscopCidade() {
    }

    public SiscopCidade(Long codigo) {
        this.codigo = codigo;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public SiscopUnidadeFederacao getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    public void setUnidadeFederacao(SiscopUnidadeFederacao unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getCodigoIbge() {
        return this.codigoIbge;
    }

    public void setCodigoIbge(String codigoIbge) {
        this.codigoIbge = codigoIbge;
    }

    public Long getCodigoAplic() {
        return this.codigoAplic;
    }

    public void setCodigoAplic(Long codigoAplic) {
        this.codigoAplic = codigoAplic;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Boolean getAtivo() {
        return Boolean.TRUE.equals(this.ativo);
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public SiscopCidade withCodigo(Long codigo) {
        this.codigo = codigo;
        return this;
    }

    @Generated
    public String toString() {
        return "SiscopCidade(codigo=" + this.getCodigo() + ", unidadeFederacao=" + String.valueOf(this.getUnidadeFederacao()) + ", descricao=" + this.getDescricao() + ", codigoIbge=" + this.getCodigoIbge() + ", codigoAplic=" + this.getCodigoAplic() + ", idUnico=" + this.getIdUnico() + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiscopCidade)) {
            return false;
        }
        SiscopCidade other = (SiscopCidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiscopCidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

