/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.siscop.SiscopCidade;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="siscop.bairro")
@DynamicInsert
@DynamicUpdate
public class SiscopBairro
implements Replicable<Bairro, Long> {
    @Id
    @EloSequence
    @Column(name="bairro")
    private Long codigo;
    @ManyToOne
    @JoinColumn
    @NotNull
    private SiscopCidade cidade;
    @Length(max=100)
    private @Length(max=100) String descricao;
    private Long idUnico;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public SiscopCidade getCidade() {
        return this.cidade;
    }

    public void setCidade(SiscopCidade cidade) {
        this.cidade = cidade;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Boolean getAtivo() {
        return Boolean.TRUE.equals(this.ativo);
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public SiscopBairro withCodigo(long codigo) {
        this.setCodigo(Long.valueOf(codigo));
        return this;
    }

    @Generated
    public String toString() {
        return "SiscopBairro(codigo=" + this.getCodigo() + ", cidade=" + String.valueOf(this.getCidade()) + ", descricao=" + this.getDescricao() + ", idUnico=" + this.getIdUnico() + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiscopBairro)) {
            return false;
        }
        SiscopBairro other = (SiscopBairro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiscopBairro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

