/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.shared.solicitacaoassinatura;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.Envelope;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SituacaoSolicitacaoAssinatura;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SolicitacaoAssinaturaArquivo;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SolicitacaoAssinaturaPessoa;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table(name="eloarquivo.solicitacaoassinatura")
@JsonFilterFields(of={"id", "dataSolicitacao", "username", "descricao", "situacao", "destinatarios.id", "destinatarios.destinatario.id", "destinatarios.destinatario.nome", "arquivos.id", "arquivos.arquivo.id", "arquivos.arquivo.nome"})
public class SolicitacaoAssinatura
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="s_solicitacaoassinatura")
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotNull
    @Caption(value="Data de Solicita\u00e7\u00e3o")
    @Column(name="datasolicitacao")
    private LocalDate dataSolicitacao;
    @NotEmpty
    @Caption(value="Solicitante")
    private String username;
    @NotEmpty
    @Caption(value="Descri\u00e7\u00e3o")
    private String descricao;
    @NotNull
    @Caption(value="Situa\u00e7\u00e3o")
    @Enumerated(value=EnumType.STRING)
    private SituacaoSolicitacaoAssinatura situacao = SituacaoSolicitacaoAssinatura.ABERTA;
    @JsonIgnore
    @MetaModelIgnore
    @Caption(value="Envelopes")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="solicitacaoAssinatura", orphanRemoval=true, cascade={CascadeType.ALL})
    private final List<Envelope> envelopes = new ArrayList();
    @Caption(value="Destinat\u00e1rios")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="solicitacaoAssinatura", orphanRemoval=true, cascade={CascadeType.ALL})
    private final List<SolicitacaoAssinaturaPessoa> destinatarios = new ArrayList();
    @Caption(value="Arquivos")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="solicitacaoAssinatura", orphanRemoval=true, cascade={CascadeType.ALL})
    private final List<SolicitacaoAssinaturaArquivo> arquivos = new ArrayList();

    public boolean isPendente() {
        return SituacaoSolicitacaoAssinatura.ABERTA.equals((Object)this.getSituacao()) || SituacaoSolicitacaoAssinatura.EM_ANDAMENTO.equals((Object)this.getSituacao());
    }

    @Generated
    public SolicitacaoAssinatura() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public SituacaoSolicitacaoAssinatura getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<Envelope> getEnvelopes() {
        return this.envelopes;
    }

    @Generated
    public List<SolicitacaoAssinaturaPessoa> getDestinatarios() {
        return this.destinatarios;
    }

    @Generated
    public List<SolicitacaoAssinaturaArquivo> getArquivos() {
        return this.arquivos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDataSolicitacao(LocalDate dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setSituacao(SituacaoSolicitacaoAssinatura situacao) {
        this.situacao = situacao;
    }

    @Generated
    public String toString() {
        return "SolicitacaoAssinatura(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolicitacaoAssinatura)) {
            return false;
        }
        SolicitacaoAssinatura other = (SolicitacaoAssinatura)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SolicitacaoAssinatura;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

