/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.shared.solicitacaoassinatura;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SituacaoEnvelopeAssinatura;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SolicitacaoAssinatura;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table(name="eloarquivo.envelope")
@JsonFilterFields(of={"id", "dataAbertura", "dataAssinatura", "situacao", "destinatario.id", "destinatario.nome", "arquivo.id", "arquivo.nome", "solicitacaoAssinatura.id", "solicitacaoAssinatura.dataSolicitacao", "solicitacaoAssinatura.descricao", "solicitacaoAssinatura.username", "solicitacaoAssinatura.situacao"})
public class Envelope
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="s_envelope")
    @Caption(value="C\u00f3digo")
    private Long id;
    @Caption(value="Data de Abertura")
    @Column(name="dataabertura")
    private LocalDate dataAbertura;
    @Caption(value="Data da Assinatura")
    @Column(name="dataassinatura")
    private LocalDate dataAssinatura;
    @Caption(value="Situa\u00e7\u00e3o")
    @Enumerated(value=EnumType.STRING)
    private SituacaoEnvelopeAssinatura situacao = SituacaoEnvelopeAssinatura.PENDENTE;
    @NotNull
    @Caption(value="Destinat\u00e1rio")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="destinatario", referencedColumnName="id")
    private Pessoa destinatario;
    @NotNull
    @Caption(value="Arquivo")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="arquivo", referencedColumnName="id")
    private Arquivo arquivo;
    @NotNull
    @Caption(value="Solicita\u00e7\u00e3o Assinatura")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="solicitacaoassinatura", referencedColumnName="id")
    private SolicitacaoAssinatura solicitacaoAssinatura;

    public boolean isPendente() {
        return SituacaoEnvelopeAssinatura.PENDENTE.equals((Object)this.getSituacao());
    }

    @Generated
    public Envelope() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    @Generated
    public LocalDate getDataAssinatura() {
        return this.dataAssinatura;
    }

    @Generated
    public SituacaoEnvelopeAssinatura getSituacao() {
        return this.situacao;
    }

    @Generated
    public Pessoa getDestinatario() {
        return this.destinatario;
    }

    @Generated
    public Arquivo getArquivo() {
        return this.arquivo;
    }

    @Generated
    public SolicitacaoAssinatura getSolicitacaoAssinatura() {
        return this.solicitacaoAssinatura;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Generated
    public void setDataAssinatura(LocalDate dataAssinatura) {
        this.dataAssinatura = dataAssinatura;
    }

    @Generated
    public void setSituacao(SituacaoEnvelopeAssinatura situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDestinatario(Pessoa destinatario) {
        this.destinatario = destinatario;
    }

    @Generated
    public void setArquivo(Arquivo arquivo) {
        this.arquivo = arquivo;
    }

    @Generated
    public void setSolicitacaoAssinatura(SolicitacaoAssinatura solicitacaoAssinatura) {
        this.solicitacaoAssinatura = solicitacaoAssinatura;
    }

    @Generated
    public String toString() {
        return "Envelope(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Envelope;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

