/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.shared;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.CalculatedModel;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.TipoAssinatura;
import br.com.elotech.di.validation.SkipBatchValidation;
import br.com.elotech.utils.pdf.sign.PdfStamper;
import java.time.LocalDate;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="eloarquivo.assinaturadigital")
@DynamicUpdate
@SkipBatchValidation
@JsonFilterFields(of={"id", "nome", "senha", "dataCriacao", "dataAlteracao", "usuarioCriacao", "usuarioAlteracao", "tipoAssinatura", "arquivo", "arquivo.id", "arquivo.nome", "width", "height"})
public class AssinaturaDigital
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="GEN_ASSINATURADIGITAL")
    @Caption(value="C\u00f3digo")
    private Long id;
    @Column(length=150)
    @Caption(value="Nome")
    private String nome;
    @Column(length=60)
    @Caption(value="Senha")
    private String senha;
    @Caption(value="Arquivo")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="idarquivo")
    private Arquivo arquivo;
    @Caption(value="Data Cria\u00e7\u00e3o")
    private LocalDate dataCriacao;
    @Caption(value="Data Altera\u00e7\u00e3o")
    private LocalDate dataAlteracao;
    @ManyToOne
    @Caption(value="Usuario Cria\u00e7\u00e3o")
    private Usuario usuarioCriacao;
    @ManyToOne
    @Caption(value="Usuario Altera\u00e7\u00e3o")
    private Usuario usuarioAlteracao;
    @Enumerated(value=EnumType.STRING)
    @Caption(value="Tipo Assinatura")
    private TipoAssinatura tipoAssinatura;

    @CalculatedModel(fieldPath="width", caption="Largura")
    public float getWidth() {
        if (TipoAssinatura.ASSINATURA_ELETRONICA.equals((Object)this.tipoAssinatura)) {
            return PdfStamper.builder().pngInputFile(this.arquivo.getContent().getBinary()).build().getPngWidth();
        }
        return 0.0f;
    }

    @CalculatedModel(fieldPath="height", caption="Altura")
    public float getHeight() {
        if (TipoAssinatura.ASSINATURA_ELETRONICA.equals((Object)this.tipoAssinatura)) {
            return PdfStamper.builder().pngInputFile(this.arquivo.getContent().getBinary()).build().getPngHeight();
        }
        return 0.0f;
    }

    @Generated
    public AssinaturaDigital() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getSenha() {
        return this.senha;
    }

    @Generated
    public Arquivo getArquivo() {
        return this.arquivo;
    }

    @Generated
    public LocalDate getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public Usuario getUsuarioCriacao() {
        return this.usuarioCriacao;
    }

    @Generated
    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    @Generated
    public TipoAssinatura getTipoAssinatura() {
        return this.tipoAssinatura;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Generated
    public void setArquivo(Arquivo arquivo) {
        this.arquivo = arquivo;
    }

    @Generated
    public void setDataCriacao(LocalDate dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setUsuarioCriacao(Usuario usuarioCriacao) {
        this.usuarioCriacao = usuarioCriacao;
    }

    @Generated
    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    @Generated
    public void setTipoAssinatura(TipoAssinatura tipoAssinatura) {
        this.tipoAssinatura = tipoAssinatura;
    }

    @Generated
    public String toString() {
        return "AssinaturaDigital(id=" + this.getId() + ", nome=" + this.getNome() + ", usuarioCriacao=" + String.valueOf(this.getUsuarioCriacao()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssinaturaDigital)) {
            return false;
        }
        AssinaturaDigital other = (AssinaturaDigital)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssinaturaDigital;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

