/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.shared;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.shared.ArquivoContent;
import br.com.elotech.di.domain.shared.MetaDadoValor;
import br.com.elotech.di.domain.shared.TipoArquivo;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.di.validation.SkipBatchValidation;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import br.com.elotech.unico.client.intf.EloArquivo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="eloarquivo.arquivo")
@DynamicUpdate
@SkipBatchValidation
public class Arquivo
extends EloDomain<Long>
implements EloEntity<Long>,
EloArquivo {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="GEN_ELOARQUIVO")
    @Caption(value="C\u00f3digo")
    private Long id;
    @Column(length=2000)
    @Caption(value="Nome Arquivo")
    private String nome;
    @Caption(value="Data Cria\u00e7\u00e3o")
    private LocalDate dataCriacao;
    @Caption(value="Conte\u00fado")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="arquivo")
    private ArquivoContent content = new ArquivoContent().withArquivo(this);
    @Caption(value="Usu\u00e1rio")
    @Column(name="usuario", columnDefinition="uuid")
    private UUID usuario;
    @Caption(value="MIME type")
    @Column(name="mimetype", length=200)
    private String mimeType;
    @Caption(value="Caminho completo")
    @Column(name="fullPath", length=1200)
    private String fullPath;
    @Caption(value="Caminho completo original")
    @Column(name="fullpathoriginal", length=1200)
    private String fullPathOriginal;
    @Caption(value="Tipo Arquivo")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tipo", referencedColumnName="id")
    private TipoArquivo tipo;
    @Caption(value="M\u00f3dulo")
    @Enumerated(value=EnumType.STRING)
    private Modulo modulo;
    @Caption(value="Migrado")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean migrado = Boolean.FALSE;
    @Caption(value="Data Migra\u00e7\u00e3o In\u00edcio")
    @Column(name="migrado_datetime_start")
    private LocalDateTime migradoDateTimeStart;
    @Caption(value="Data Migra\u00e7\u00e3o Fim")
    @Column(name="migrado_datetime_end")
    private LocalDateTime migradoDateTimeEnd;
    @Caption(value="Migrado Usu\u00e1rio")
    @Column(name="migrado_usuario")
    private String migradoUsuario;
    @Caption(value="C\u00f3digo Autenticidade")
    @Column(name="codigo_autenticidade")
    private String codigoAutenticidade;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="id_arquivo", updatable=false, nullable=false)
    private List<MetaDadoValor> metaDados = new ArrayList();

    @JsonCreator
    public Arquivo(@JsonProperty(value="id") Long id, @JsonProperty(value="nome") String nome, @JsonProperty(value="dataCriacao") LocalDate dataCriacao, @JsonProperty(value="content") ArquivoContent content, @JsonProperty(value="usuario") UUID usuario, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="fullPath") String fullPath, @JsonProperty(value="fullPathOriginal") String fullPathOrignal, @JsonProperty(value="tipo") TipoArquivo tipo, @JsonProperty(value="modulo") Modulo modulo, @JsonProperty(value="metaDados") List<MetaDadoValor> metaDados) {
        this.id = id;
        this.nome = nome;
        this.dataCriacao = dataCriacao;
        if (Objects.isNull(Optional.ofNullable(content).orElse(new ArquivoContent()).getBinary())) {
            this.setContent(null);
        } else {
            this.content.setId(id);
            this.content.setBinary(content.getBinary());
        }
        this.setUsuario(usuario);
        this.setMimeType(mimeType);
        this.setFullPath(fullPath);
        this.setFullPathOriginal(Optional.ofNullable(fullPathOrignal).orElse(fullPath));
        this.setTipo(tipo);
        this.setModulo(modulo);
        this.setMetaDados(metaDados);
    }

    public static Arquivo of(Long id, String nome) {
        Arquivo arquivo = new Arquivo();
        arquivo.setId(id);
        arquivo.setNome(nome);
        return arquivo;
    }

    public static Arquivo ofDTO(ArquivoDTO dto) {
        Arquivo arquivo = new Arquivo();
        arquivo.setNome(dto.getNome());
        arquivo.setDataCriacao(dto.getDataCriacao());
        arquivo.setUsuario(dto.getUsuario());
        arquivo.setMimeType(dto.getMimeType());
        arquivo.setFullPath(dto.getFullPath());
        arquivo.setFullPathOriginal(dto.getFullPathOriginal());
        arquivo.setModulo(dto.getModulo());
        return arquivo;
    }

    public ArquivoDTO toDTO() {
        ArquivoDTO dto = new ArquivoDTO();
        dto.setId(this.id);
        dto.setNome(this.nome);
        dto.setDataCriacao(this.dataCriacao);
        dto.setUsuario(this.usuario);
        dto.setMimeType(this.mimeType);
        dto.setFullPathOriginal(this.fullPathOriginal);
        dto.setFullPath(this.fullPath);
        dto.setModulo(this.modulo);
        dto.setTipo(Optional.ofNullable(this.tipo).map(TipoArquivo::getTipo).orElse(TipoArquivoEnum.OUTROS));
        return dto;
    }

    @NotEmpty(groups={SkipBatch.class})
    @Length(max=2000)
    public @NotEmpty(groups={SkipBatch.class}) @Length(max=2000) String getNome() {
        return this.nome;
    }

    @JsonIgnore
    public Boolean isS3File() {
        return Objects.nonNull(this.fullPath);
    }

    public void safeSetFieldsForS3(TipoArquivo tipoArquivo, Modulo modulo, String usuario) {
        if (this.isS3File().booleanValue()) {
            this.setContent(null);
            this.setModulo(modulo);
            this.setTipo(tipoArquivo);
            if (Objects.isNull(this.getUsuario())) {
                this.setUsuario(UUID.fromString(usuario));
            }
        }
    }

    public String getDescricaoModulo() {
        if (Objects.nonNull(this.modulo)) {
            return this.modulo.getDescricao();
        }
        return "";
    }

    @Generated
    public Arquivo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public ArquivoContent getContent() {
        return this.content;
    }

    @Generated
    public UUID getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Generated
    public String getFullPath() {
        return this.fullPath;
    }

    @Generated
    public String getFullPathOriginal() {
        return this.fullPathOriginal;
    }

    @Generated
    public TipoArquivo getTipo() {
        return this.tipo;
    }

    @Generated
    public Modulo getModulo() {
        return this.modulo;
    }

    @Generated
    public Boolean getMigrado() {
        return this.migrado;
    }

    @Generated
    public LocalDateTime getMigradoDateTimeStart() {
        return this.migradoDateTimeStart;
    }

    @Generated
    public LocalDateTime getMigradoDateTimeEnd() {
        return this.migradoDateTimeEnd;
    }

    @Generated
    public String getMigradoUsuario() {
        return this.migradoUsuario;
    }

    @Generated
    public String getCodigoAutenticidade() {
        return this.codigoAutenticidade;
    }

    @Generated
    public List<MetaDadoValor> getMetaDados() {
        return this.metaDados;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setDataCriacao(LocalDate dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public void setContent(ArquivoContent content) {
        this.content = content;
    }

    @Generated
    public void setUsuario(UUID usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Generated
    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    @Generated
    public void setFullPathOriginal(String fullPathOriginal) {
        this.fullPathOriginal = fullPathOriginal;
    }

    @Generated
    public void setTipo(TipoArquivo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setModulo(Modulo modulo) {
        this.modulo = modulo;
    }

    @Generated
    public void setMigrado(Boolean migrado) {
        this.migrado = migrado;
    }

    @Generated
    public void setMigradoDateTimeStart(LocalDateTime migradoDateTimeStart) {
        this.migradoDateTimeStart = migradoDateTimeStart;
    }

    @Generated
    public void setMigradoDateTimeEnd(LocalDateTime migradoDateTimeEnd) {
        this.migradoDateTimeEnd = migradoDateTimeEnd;
    }

    @Generated
    public void setMigradoUsuario(String migradoUsuario) {
        this.migradoUsuario = migradoUsuario;
    }

    @Generated
    public void setCodigoAutenticidade(String codigoAutenticidade) {
        this.codigoAutenticidade = codigoAutenticidade;
    }

    @Generated
    public void setMetaDados(List<MetaDadoValor> metaDados) {
        this.metaDados = metaDados;
    }

    @Generated
    public String toString() {
        return "Arquivo(id=" + this.getId() + ", nome=" + this.getNome() + ", dataCriacao=" + String.valueOf(this.getDataCriacao()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Arquivo)) {
            return false;
        }
        Arquivo other = (Arquivo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Arquivo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

