/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.query.param;

import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.enums.DataType;
import br.com.elotech.di.domain.enums.QueryOperator;
import br.com.elotech.di.domain.query.QueryField;
import br.com.elotech.di.domain.query.param.AbstractQueryFilter;
import br.com.elotech.di.domain.query.param.QueryInputType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

@Table(name="unico.jdbcqueryfilter")
@Entity
@JsonFilterFields(of={"id", "field.id", "field.caption", "field.name", "field.type", "operator", "name", "required", "type", "defaultValue", "dataType", "inputType", "columnAlias", "query.id"})
public class JDBCQueryFilter
extends AbstractQueryFilter {
    @ManyToOne
    @JoinColumn(name="queryfield_id")
    private QueryField field;
    @Transient
    private QueryOperator operator;
    @Transient
    private boolean selected;

    public JDBCQueryFilter(QueryField field, String name, Boolean required, String defaultValue, Integer order, QueryInputType inputType) {
        super(null, name, required, defaultValue, order, inputType, field.getType(), null, null);
    }

    public JDBCQueryFilter(String name, String value) {
        super(null, name, Boolean.valueOf(false), null, null, null, null, null, value);
    }

    public void setField(QueryField field) {
        this.field = field;
        if (Objects.nonNull(field)) {
            this.setDataType(field.getType());
        } else {
            this.setDataType(null);
        }
    }

    public boolean isSelected() {
        return this.selected || this.getRequired() != false;
    }

    public QueryOperator getOperator() {
        if (Objects.isNull(this.operator)) {
            return QueryOperator.EQUAL;
        }
        return this.operator;
    }

    @JsonIgnore
    public String getCondition() {
        String format = DataType.TEXTO.equals((Object)this.getDataType()) ? "lower(%s) %s lower(%s)" : "%s %s %s";
        String resultingName = !StringUtils.isBlank((String)this.getField().getAlias()) ? this.getField().getAlias() + "." + this.getField().getName() : this.getField().getTableName() + "." + this.getField().getName();
        return String.format(format, resultingName, this.getDataType().operatorToString(this.getOperator().getComparisonOperator()), this.getDataType().stringToSqlString(this.getValue()));
    }

    @Generated
    public QueryField getField() {
        return this.field;
    }

    @Generated
    public void setOperator(QueryOperator operator) {
        this.operator = operator;
    }

    @Generated
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Generated
    public String toString() {
        return "JDBCQueryFilter(field=" + String.valueOf(this.getField()) + ", operator=" + String.valueOf(this.getOperator()) + ", selected=" + this.isSelected() + ")";
    }

    @Generated
    public JDBCQueryFilter() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JDBCQueryFilter)) {
            return false;
        }
        JDBCQueryFilter other = (JDBCQueryFilter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSelected() != other.isSelected()) {
            return false;
        }
        QueryField this$field = this.getField();
        QueryField other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        QueryOperator this$operator = this.getOperator();
        QueryOperator other$operator = other.getOperator();
        return !(this$operator == null ? other$operator != null : !this$operator.equals(other$operator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JDBCQueryFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSelected() ? 79 : 97);
        QueryField $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        QueryOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        return result;
    }
}

