/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.query.param;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.di.domain.enums.DataType;
import br.com.elotech.di.domain.query.AbstractQuery;
import br.com.elotech.di.domain.query.param.APIQueryFilter;
import br.com.elotech.di.domain.query.param.JDBCQueryFilter;
import br.com.elotech.di.domain.query.param.QueryInputType;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="typeValue")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JDBCQueryFilter.class, name="JDBC"), @JsonSubTypes.Type(value=APIQueryFilter.class, name="API")})
public abstract class AbstractQueryFilter {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="s_param")
    private Long id;
    @NotNull
    private String name;
    @NotNull
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean required = false;
    private String defaultValue;
    private Integer orderParam;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private QueryInputType inputType;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private DataType dataType;
    @ManyToOne
    @MetaModelIgnore
    @JoinColumn(name="query_id")
    @JsonBackReference
    private AbstractQuery query;
    @Transient
    private String value;

    public String getValue() {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            return this.getDefaultValue();
        }
        return this.value;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getRequired() {
        return this.required;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Integer getOrderParam() {
        return this.orderParam;
    }

    @Generated
    public QueryInputType getInputType() {
        return this.inputType;
    }

    @Generated
    public DataType getDataType() {
        return this.dataType;
    }

    @Generated
    public AbstractQuery getQuery() {
        return this.query;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setOrderParam(Integer orderParam) {
        this.orderParam = orderParam;
    }

    @Generated
    public void setInputType(QueryInputType inputType) {
        this.inputType = inputType;
    }

    @Generated
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setQuery(AbstractQuery query) {
        this.query = query;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public String toString() {
        return "AbstractQueryFilter(id=" + this.getId() + ", name=" + this.getName() + ", required=" + this.getRequired() + ", defaultValue=" + this.getDefaultValue() + ", orderParam=" + this.getOrderParam() + ", inputType=" + String.valueOf(this.getInputType()) + ", dataType=" + String.valueOf(this.getDataType()) + ", query=" + String.valueOf(this.getQuery()) + ", value=" + this.getValue() + ")";
    }

    @Generated
    public AbstractQueryFilter() {
    }

    @Generated
    public AbstractQueryFilter(Long id, String name, Boolean required, String defaultValue, Integer orderParam, QueryInputType inputType, DataType dataType, AbstractQuery query, String value) {
        this.id = id;
        this.name = name;
        this.required = required;
        this.defaultValue = defaultValue;
        this.orderParam = orderParam;
        this.inputType = inputType;
        this.dataType = dataType;
        this.query = query;
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractQueryFilter)) {
            return false;
        }
        AbstractQueryFilter other = (AbstractQueryFilter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractQueryFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

