/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.query;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.MetaModelField;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.enums.DataType;
import br.com.elotech.di.domain.query.AbstractQuery;
import br.com.elotech.di.domain.query.OrderedField;
import br.com.elotech.di.domain.query.QueryResult;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="unico.queryfield")
@JsonFilterFields(of={"id", "caption", "name", "tableName", "caption", "alias", "type", "query.id"})
public class QueryField
implements EloEntity<Long>,
Comparable<QueryField> {
    @Id
    @EloSequence(applyOnMerge=true)
    private Long id;
    private String caption;
    @NotNull
    private String tableName;
    private String alias;
    @NotNull
    private String name;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private DataType type;
    @ManyToOne
    @JoinColumn(name="query_id")
    @MetaModelIgnore
    @JsonBackReference
    private AbstractQuery query;
    @Transient
    private int order;

    public static QueryField of(QueryResult qr) {
        QueryField qf = new QueryField();
        qf.setId(qr.getId());
        qf.setTableName(qr.getTableName());
        qf.setAlias(qr.getAlias());
        qf.setName(qr.getName());
        qf.setCaption(qr.getCaption());
        qf.setType(qr.getType());
        qf.setQuery(qr.getQuery());
        return qf;
    }

    public OrderedField getOrderedField() {
        if (StringUtils.isBlank((CharSequence)this.caption)) {
            return new OrderedField(this.getName(), this.getName(), this.order);
        }
        return new OrderedField(this.caption, this.getName(), this.order);
    }

    public static QueryField create(Long id, String caption, String tableName, String alias, String name, DataType type) {
        return new QueryField(id, caption, tableName, alias, name, type, null, 0);
    }

    @Override
    public int compareTo(QueryField o) {
        return this.order - o.getOrder();
    }

    @JsonIgnore
    public MetaModelField toMetaModelField() {
        MetaModelField metaModelField = new MetaModelField();
        metaModelField.setCaption(this.caption);
        metaModelField.setFieldName(this.name);
        metaModelField.setFieldPath(this.name);
        metaModelField.setFieldFullPath(this.name);
        return metaModelField;
    }

    public String getAlias() {
        if (Objects.isNull(this.alias)) {
            return "";
        }
        return this.alias;
    }

    public String getNameForSQL() {
        if (StringUtils.isBlank((CharSequence)this.alias)) {
            return this.tableName + "." + this.name;
        }
        return this.alias + "." + this.name;
    }

    public String getMapProperty() {
        return this.caption;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DataType getType() {
        return this.type;
    }

    @Generated
    public AbstractQuery getQuery() {
        return this.query;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(DataType type) {
        this.type = type;
    }

    @Generated
    public void setQuery(AbstractQuery query) {
        this.query = query;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public String toString() {
        return "QueryField(id=" + this.getId() + ", caption=" + this.getCaption() + ", tableName=" + this.getTableName() + ", alias=" + this.getAlias() + ", name=" + this.getName() + ", type=" + String.valueOf(this.getType()) + ", query=" + String.valueOf(this.getQuery()) + ", order=" + this.getOrder() + ")";
    }

    @Generated
    public QueryField() {
    }

    @Generated
    public QueryField(Long id, String caption, String tableName, String alias, String name, DataType type, AbstractQuery query, int order) {
        this.id = id;
        this.caption = caption;
        this.tableName = tableName;
        this.alias = alias;
        this.name = name;
        this.type = type;
        this.query = query;
        this.order = order;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryField)) {
            return false;
        }
        QueryField other = (QueryField)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

