/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.query;

import br.com.elotech.di.domain.enums.DataType;
import br.com.elotech.di.domain.query.AbstractQuery;
import br.com.elotech.di.domain.query.JDBCQuery;
import br.com.elotech.di.domain.query.QueryExecution;
import br.com.elotech.di.domain.query.QueryExecutor;
import br.com.elotech.di.domain.query.QueryField;
import br.com.elotech.di.domain.query.QueryResult;
import br.com.elotech.di.domain.query.param.AbstractQueryFilter;
import br.com.elotech.di.domain.query.param.JDBCQueryFilter;
import br.com.elotech.di.exception.QueryExecutionException;
import br.com.elotech.di.exception.RuntimeQueryExecutionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.jdbc.PgResultSetMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class JDBCQueryExecutor
implements QueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCQueryExecutor.class);
    public static final String REGEX_TABLE_ALIAS = "(?!where|on|join)(?<=[ \\n\\r|.]%s[ \\n\\r])([a-zA-Z0-9_])+";
    public static final String MENSAGEM_ERRO_DEFAULT = "Erro ao consultar banco de dados";
    private final DataSource tenantDatasource;

    public Page<List<QueryResult>> execute(AbstractQuery abstractQuery, Pageable page) throws QueryExecutionException {
        JDBCQuery query = (JDBCQuery)abstractQuery;
        if (StringUtils.isBlank((CharSequence)query.getSql())) {
            return new PageImpl(Collections.emptyList());
        }
        List filtrosSelecionados = query.getFilters().stream().map(JDBCQueryFilter.class::cast).filter(JDBCQueryFilter::isSelected).collect(Collectors.toList());
        return (Page)this.executeSql(statement -> {
            String sql = this.appendFilters(query, query.getSql(), filtrosSelecionados);
            if (page.isPaged()) {
                int total = this.countTotal(sql, statement);
                sql = this.appendSort(page, query, sql);
                sql = this.paginate(sql, page);
                List queryResult = this.getQueryResult(query, statement, sql);
                return new PageImpl(queryResult, page, (long)total);
            }
            sql = this.appendSort(page, query, sql);
            return new PageImpl(this.getQueryResult(query, statement, sql));
        });
    }

    private String appendSort(Pageable page, JDBCQuery query, String sql) {
        if (page.getSort().isSorted()) {
            String[] sort = page.getSort().toString().split(":");
            String fieldName = sort[0];
            QueryField queryField = query.getFields().stream().filter(f -> f.getName().equalsIgnoreCase(fieldName)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("N\u00e3o foi encontrado o campo com nome %s", fieldName)));
            return sql + " order by " + queryField.getNameForSQL() + " " + sort[1];
        }
        return sql;
    }

    public List<QueryResult> generateFields(AbstractQuery abstractQuery) throws QueryExecutionException {
        JDBCQuery query = (JDBCQuery)abstractQuery;
        if (StringUtils.isBlank((CharSequence)query.getSql())) {
            return Collections.emptyList();
        }
        return (List)this.executeSql(statement -> this.getQueryFields(query, statement, query.getSql()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <R> R executeSql(QueryExecution<Statement, R> callback) throws QueryExecutionException {
        try (Connection connection = this.tenantDatasource.getConnection();){
            Object object;
            block14: {
                Statement statement = connection.createStatement();
                try {
                    object = callback.apply((Object)statement);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return (R)object;
        }
        catch (SQLException throwables) {
            LOGGER.error(MENSAGEM_ERRO_DEFAULT, (Throwable)throwables);
            throw new QueryExecutionException(MENSAGEM_ERRO_DEFAULT, (Exception)throwables);
        }
    }

    private List<List<QueryResult>> getQueryResult(JDBCQuery query, Statement statement, String sql) throws QueryExecutionException {
        try {
            LOGGER.info("JDBCQueryExecutor -> sql sendo executado -> " + sql);
            statement.execute(sql);
            List list = this.findQueryResult(query, statement);
            return list;
        }
        catch (SQLException throwables) {
            LOGGER.error(MENSAGEM_ERRO_DEFAULT, (Throwable)throwables);
            throw new QueryExecutionException(MENSAGEM_ERRO_DEFAULT, (Exception)throwables);
        }
        finally {
            LOGGER.info("JDBCQueryExecutor -> Fim da execu\u00e7\u00e3o");
        }
    }

    private List<QueryResult> getQueryFields(JDBCQuery query, Statement statement, String sql) throws QueryExecutionException {
        try {
            statement.execute(sql + " limit 1");
            ArrayList<QueryResult> result = new ArrayList<QueryResult>();
            List generated = this.generateQueryResult(query, statement);
            HashMap captionCounter = new HashMap();
            generated.forEach(queryResult -> {
                Long countVal = 0L;
                if (captionCounter.containsKey(queryResult.getCaption())) {
                    countVal = (Long)captionCounter.get(queryResult.getCaption()) + 1L;
                }
                captionCounter.put(queryResult.getCaption(), countVal);
                String newCaption = queryResult.getCaption() + this.toString(countVal);
                queryResult.setCaption(newCaption);
                queryResult.setOrder(generated.indexOf(queryResult));
                result.add((QueryResult)queryResult);
            });
            return result;
        }
        catch (SQLException throwables) {
            LOGGER.error(MENSAGEM_ERRO_DEFAULT, (Throwable)throwables);
            throw new QueryExecutionException(MENSAGEM_ERRO_DEFAULT, (Exception)throwables);
        }
    }

    private String toString(Long countVal) {
        return countVal > 0L ? String.valueOf(countVal) : "";
    }

    private String paginate(String sql, Pageable page) {
        int inicio = page.getPageNumber() * page.getPageSize();
        return sql + String.format(" limit %s offset %s", page.getPageSize(), inicio);
    }

    private int countTotal(String sql, Statement statement) throws QueryExecutionException {
        int total = 0;
        try {
            statement.execute("select count(*) from " + sql.split("from")[1]);
            try (ResultSet resultSet = statement.getResultSet();){
                if (resultSet.next()) {
                    total = resultSet.getInt(1);
                }
            }
        }
        catch (SQLException throwables) {
            LOGGER.error(MENSAGEM_ERRO_DEFAULT, (Throwable)throwables);
            throw new QueryExecutionException(MENSAGEM_ERRO_DEFAULT, (Exception)throwables);
        }
        return total;
    }

    private List<List<QueryResult>> findQueryResult(JDBCQuery query, Statement statement) throws SQLException, QueryExecutionException {
        ArrayList<List<QueryResult>> result = new ArrayList<List<QueryResult>>();
        try (ResultSet resultSet = statement.getResultSet();){
            while (resultSet.next()) {
                int index = result.size();
                result.add(new ArrayList());
                int colCont = 0;
                ResultSetMetaData metaData = resultSet.getMetaData();
                List currentRecord = (List)result.get(index);
                List fields = this.getQueryFields(query);
                while (colCont++ < metaData.getColumnCount()) {
                    String data = resultSet.getString(colCont);
                    String name = this.getFieldName(colCont, metaData);
                    String tableName = this.getTableName(colCont, metaData);
                    String alias = this.innerGetAlias(query.getSql(), metaData.getTableName(colCont));
                    for (int i = 0; i < fields.size(); ++i) {
                        QueryField field = (QueryField)fields.get(i);
                        if (!field.getName().equalsIgnoreCase(name) || !field.getAlias().equalsIgnoreCase(alias) || !field.getTableName().equalsIgnoreCase(tableName)) continue;
                        currentRecord.add(QueryResult.create((QueryField)field, (String)data, (int)colCont));
                        fields.remove(field);
                    }
                }
            }
        }
        return result;
    }

    private List<QueryField> getQueryFields(JDBCQuery query) throws QueryExecutionException {
        if (query.getFields().isEmpty()) {
            return this.generateFields((AbstractQuery)query);
        }
        return new ArrayList<QueryField>(query.getFields());
    }

    private List<QueryResult> generateQueryResult(JDBCQuery query, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.getResultSet();){
            List result = this.extractRecord(query, resultSet);
            if (result.isEmpty()) {
                ArrayList<QueryResult> arrayList = new ArrayList<QueryResult>();
                return arrayList;
            }
            List list = (List)result.get(0);
            return list;
        }
    }

    private List<List<QueryResult>> extractRecord(JDBCQuery query, ResultSet resultSet) throws SQLException {
        ArrayList<List<QueryResult>> result = new ArrayList<List<QueryResult>>();
        while (resultSet.next()) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            List currentRecord = this.createRecord(query, resultSet, metaData);
            result.add(currentRecord);
        }
        return result;
    }

    private List<QueryResult> createRecord(JDBCQuery query, ResultSet resultSet, ResultSetMetaData metaData) throws SQLException {
        List indexes = this.createIndexesList(metaData);
        return indexes.parallelStream().map(colCont -> {
            try {
                QueryResult createdField = this.createField(query, resultSet, colCont.intValue(), metaData);
                query.getFields().parallelStream().filter(dt -> dt.getName().equalsIgnoreCase(createdField.getName())).findAny().ifPresent(dt -> createdField.setCaption(dt.getCaption()));
                return createdField;
            }
            catch (SQLException throwables) {
                LOGGER.error(MENSAGEM_ERRO_DEFAULT, (Throwable)throwables);
                throw new RuntimeQueryExecutionException((Throwable)throwables);
            }
        }).collect(Collectors.toList());
    }

    private List<Integer> createIndexesList(ResultSetMetaData metaData) throws SQLException {
        int colCont = 0;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (colCont++ < metaData.getColumnCount()) {
            indexes.add(colCont);
        }
        return indexes;
    }

    private QueryResult createField(JDBCQuery query, ResultSet resultSet, int colCont, ResultSetMetaData metaData) throws SQLException {
        String data = resultSet.getString(colCont);
        String label = metaData.getColumnLabel(colCont);
        String tableName = metaData.getTableName(colCont);
        String name = this.getFieldName(colCont, metaData);
        String sql = query.getSql();
        String alias = this.innerGetAlias(sql, tableName);
        DataType type = this.getType(colCont, metaData);
        String resultingTableName = this.getTableName(colCont, metaData);
        return QueryResult.create((String)label, (String)resultingTableName, (String)alias, (String)name, (DataType)type, (String)data, (int)colCont);
    }

    private String getTableName(int colCont, ResultSetMetaData metaData) throws SQLException {
        String tableName = metaData.getTableName(colCont);
        String schemaName = metaData.getSchemaName(colCont);
        if (!StringUtils.isBlank((CharSequence)schemaName)) {
            return schemaName + "." + tableName;
        }
        return tableName;
    }

    private DataType getType(int colCont, ResultSetMetaData metaData) throws SQLException {
        return switch (metaData.getColumnType(colCont)) {
            case -5, 2, 3, 4, 6, 8 -> DataType.NUMERICO;
            case 91 -> DataType.DATA;
            case 93 -> DataType.DATA_HORA;
            default -> DataType.TEXTO;
        };
    }

    private String getFieldName(int colCont, ResultSetMetaData metaData) throws SQLException {
        String tempName;
        String name = metaData.getColumnName(colCont);
        if (metaData instanceof PgResultSetMetaData && !(tempName = ((PgResultSetMetaData)metaData).getBaseColumnName(colCont)).isEmpty()) {
            name = tempName;
        }
        return name;
    }

    public String innerGetAlias(String sql, String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName) || StringUtils.isEmpty((CharSequence)sql)) {
            return "";
        }
        Pattern p = Pattern.compile(String.format(REGEX_TABLE_ALIAS, tableName));
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    private String appendFilters(JDBCQuery query, String sql, List<JDBCQueryFilter> filtrosSelecionados) {
        if (filtrosSelecionados.isEmpty()) {
            return sql;
        }
        StringBuilder sqlBuilder = new StringBuilder(sql);
        if (sqlBuilder.toString().toLowerCase().contains("where")) {
            sqlBuilder.append(" and ");
        } else {
            sqlBuilder.append(" where ");
        }
        String condicoes = filtrosSelecionados.stream().map(JDBCQueryFilter::getCondition).collect(Collectors.joining(" and "));
        sqlBuilder.append(condicoes);
        String resultingSql = sqlBuilder.toString();
        for (AbstractQueryFilter filtro : query.getFilters()) {
            if (StringUtils.isBlank((CharSequence)filtro.getValue()) && filtro.getRequired().booleanValue()) {
                IllegalArgumentException throwables = new IllegalArgumentException(String.format("O filtro %s \u00e9 requerido e n\u00e3o foi informado", filtro.getName()));
                LOGGER.error(MENSAGEM_ERRO_DEFAULT, (Throwable)throwables);
                throw throwables;
            }
            if (!Objects.nonNull(filtro.getValue())) continue;
            resultingSql = resultingSql.replace(":" + filtro.getName(), filtro.getValue());
        }
        return resultingSql;
    }

    @Generated
    public JDBCQueryExecutor(DataSource tenantDatasource) {
        this.tenantDatasource = tenantDatasource;
    }
}

