/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.query;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.datasource.DataSourceType;
import br.com.elotech.di.domain.query.APIQuery;
import br.com.elotech.di.domain.query.JDBCQuery;
import br.com.elotech.di.domain.query.QueryField;
import br.com.elotech.di.domain.query.param.AbstractQueryFilter;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="typeValue")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JDBCQuery.class, name="JDBC"), @JsonSubTypes.Type(value=APIQuery.class, name="API")})
public abstract class AbstractQuery
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="s_query")
    private Long id;
    @NotNull
    private String name;
    @Caption(value="Tipo")
    @Enumerated(value=EnumType.STRING)
    private DataSourceType type;
    @JsonManagedReference
    @OneToMany(mappedBy="query", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AbstractQueryFilter> filters = new ArrayList();
    @JsonManagedReference
    @OneToMany(mappedBy="query", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<QueryField> fields = new ArrayList();

    public void addFields(List<QueryField> fields) {
        List camposNaoAdicionados = fields.stream().filter(f -> this.fields.stream().noneMatch(tf -> tf.getName().equalsIgnoreCase(f.getName()))).collect(Collectors.toList());
        this.fields.addAll(camposNaoAdicionados);
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DataSourceType getType() {
        return this.type;
    }

    @Generated
    public List<AbstractQueryFilter> getFilters() {
        return this.filters;
    }

    @Generated
    public List<QueryField> getFields() {
        return this.fields;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(DataSourceType type) {
        this.type = type;
    }

    @Generated
    public void setFilters(List<AbstractQueryFilter> filters) {
        this.filters = filters;
    }

    @Generated
    public void setFields(List<QueryField> fields) {
        this.fields = fields;
    }

    @Generated
    public AbstractQuery() {
    }

    @Generated
    public AbstractQuery(Long id, String name, DataSourceType type, List<AbstractQueryFilter> filters, List<QueryField> fields) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.filters = filters;
        this.fields = fields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractQuery)) {
            return false;
        }
        AbstractQuery other = (AbstractQuery)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractQuery(id=" + this.getId() + ", name=" + this.getName() + ")";
    }
}

