/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.query;

import br.com.elotech.di.domain.enums.DataType;
import br.com.elotech.di.domain.enums.Method;
import br.com.elotech.di.domain.query.APIQuery;
import br.com.elotech.di.domain.query.AbstractQuery;
import br.com.elotech.di.domain.query.QueryExecutor;
import br.com.elotech.di.domain.query.QueryField;
import br.com.elotech.di.domain.query.QueryResult;
import br.com.elotech.di.exception.QueryExecutionException;
import br.com.elotech.di.exception.RuntimeQueryExecutionException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class APIQueryExecutor
implements QueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIQueryExecutor.class);
    private final ObjectMapper mapper;

    public Page<List<QueryResult>> execute(AbstractQuery abstractQuery, Pageable page) throws QueryExecutionException {
        Page page2;
        block8: {
            APIQuery query = (APIQuery)abstractQuery;
            String host = query.getPath();
            HttpURLConnection connection = this.getConnection(host, query.getMethod());
            InputStream input = connection.getInputStream();
            try {
                JsonNode json = this.mapper.readTree(input);
                page2 = this.extractList(query, json);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Erro ao extrair JSON", (Throwable)e);
                    throw new QueryExecutionException("Erro ao extrair JSON", (Exception)e);
                }
            }
            input.close();
        }
        return page2;
    }

    public List<QueryResult> generateFields(AbstractQuery abstractQuery) throws QueryExecutionException {
        return new ArrayList<QueryResult>();
    }

    private Page<List<QueryResult>> extractList(APIQuery query, JsonNode json) {
        JsonNode curr = json;
        ArrayList<List> result = new ArrayList<List>();
        List fields = query.getFields();
        Optional<QueryField> root = fields.stream().filter(f -> f.getType().equals((Object)DataType.ROOT)).findAny();
        if (root.isPresent()) {
            curr = json.get(root.get().getName());
        }
        if (curr.isArray()) {
            for (JsonNode node : curr) {
                result.add(this.extractRecord(query, node));
            }
        } else {
            result.add(this.extractRecord(query, curr));
        }
        return new PageImpl(result);
    }

    private List<QueryResult> extractRecord(APIQuery query, JsonNode node) {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>();
        List fields = query.getFields().stream().filter(f -> !f.getType().equals((Object)DataType.ROOT)).collect(Collectors.toList());
        for (QueryField field : fields) {
            String[] props = field.getName().split("\\.");
            String data = this.extractData(node, props);
            result.add(QueryResult.create((QueryField)field, (String)data));
        }
        return result;
    }

    public String extractData(JsonNode node, String[] props) {
        boolean maisDeUmRegistro;
        String curr = props[0];
        boolean bl = maisDeUmRegistro = props.length > 1;
        if (maisDeUmRegistro) {
            return this.extractData(node.get(curr), (String[])ArrayUtils.remove((Object[])props, (int)0));
        }
        if (Objects.isNull(node) || Objects.isNull(node.get(curr))) {
            return "";
        }
        return node.get(curr).asText();
    }

    public HttpURLConnection getConnection(String host, Method method) {
        try {
            URL url = new URL(host);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(method.name());
            return con;
        }
        catch (IOException e) {
            LOGGER.error("Erro ao criar conex\u00e3o", (Throwable)e);
            throw new RuntimeQueryExecutionException("Erro ao criar conex\u00e3o", (Throwable)e);
        }
    }

    @Generated
    public APIQueryExecutor(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

