/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.protocolo;

import br.com.elotech.di.domain.protocolo.ProtocoloModulo;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuario;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuarioModuloPK;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="protocolo.usrxmod")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ProtocoloUsuarioModulo {
    @EmbeddedId
    @Valid
    private final ProtocoloUsuarioModuloPK pk = new ProtocoloUsuarioModuloPK();
    private Boolean prioritario;

    public ProtocoloUsuarioModuloPK getPk() {
        return this.pk;
    }

    public Boolean getPrioritario() {
        return this.prioritario;
    }

    public void setPrioritario(Boolean prioritario) {
        this.prioritario = prioritario;
    }

    public static ProtocoloUsuarioModulo of(ProtocoloUsuario usuario, ProtocoloModulo modulo) {
        return new ProtocoloUsuarioModulo().withUsuario(usuario).withModulo(modulo);
    }

    public ProtocoloUsuarioModulo withModulo(ProtocoloModulo modulo) {
        this.pk.setModulo(modulo);
        return this;
    }

    public ProtocoloUsuarioModulo withUsuario(ProtocoloUsuario usuario) {
        this.pk.setUsuario(usuario);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocoloUsuarioModulo)) {
            return false;
        }
        ProtocoloUsuarioModulo other = (ProtocoloUsuarioModulo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProtocoloUsuarioModuloPK this$pk = this.getPk();
        ProtocoloUsuarioModuloPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtocoloUsuarioModulo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocoloUsuarioModuloPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProtocoloUsuarioModulo(pk=" + String.valueOf(this.getPk()) + ", prioritario=" + this.getPrioritario() + ")";
    }
}

