/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.protocolo;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.protocolo.ProtocoloEntidade;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuario;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuarioEntidadePK;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="protocolo.usuario_entidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ProtocoloUsuarioEntidade {
    @EmbeddedId
    @Valid
    private final ProtocoloUsuarioEntidadePK pk = new ProtocoloUsuarioEntidadePK();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean padrao;

    public Boolean getPadrao() {
        return this.padrao;
    }

    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    public ProtocoloUsuarioEntidadePK getPk() {
        return this.pk;
    }

    public static ProtocoloUsuarioEntidade of(ProtocoloUsuario usuario, ProtocoloEntidade entidade) {
        return new ProtocoloUsuarioEntidade().withUsuario(usuario).withEntidade(entidade);
    }

    public ProtocoloUsuarioEntidade withEntidade(ProtocoloEntidade entidade) {
        this.pk.setEntidade(entidade);
        return this;
    }

    public ProtocoloUsuarioEntidade withUsuario(ProtocoloUsuario usuario) {
        this.pk.setUsuario(usuario);
        return this;
    }

    public ProtocoloUsuarioEntidade withPadrao(Boolean padrao) {
        this.setPadrao(padrao);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocoloUsuarioEntidade)) {
            return false;
        }
        ProtocoloUsuarioEntidade other = (ProtocoloUsuarioEntidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProtocoloUsuarioEntidadePK this$pk = this.getPk();
        ProtocoloUsuarioEntidadePK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtocoloUsuarioEntidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocoloUsuarioEntidadePK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProtocoloUsuarioEntidade(pk=" + String.valueOf(this.getPk()) + ", padrao=" + this.getPadrao() + ")";
    }
}

