/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.protocolo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.converter.TipoPessoaEnumConverter;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.protocolo.ProtocoloEnderecoPessoa;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.validation.SkipBatch;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="protocolo.pessoa")
@DynamicInsert
@DynamicUpdate
public class ProtocoloPessoa
implements Replicable<Pessoa, Long>,
Serializable {
    @Id
    @EloSequence
    @Column(name="codpessoa")
    private Long pessoa;
    private Long idUnico;
    @Convert(converter=TipoPessoaEnumConverter.class)
    @Column(name="pessoa")
    private TipoPessoa tipoPessoa;
    @NotBlank(groups={SkipBatch.class})
    @Length(max=150)
    private @NotBlank(groups={SkipBatch.class}) @Length(max=150) String nome;
    @Length(max=40)
    private @Length(max=40) String telefone;
    @Length(max=80)
    private @Length(max=80) String endimovel;
    @Length(max=40)
    private @Length(max=40) String inscrimovel;
    @Length(max=100)
    private @Length(max=100) String email;
    @Length(max=60)
    private @Length(max=60) String celular;
    private Long sequenciaCorrespondencia;
    @Length(max=50)
    private @Length(max=50) String cargo;
    @Length(max=20)
    private @Length(max=20) String rg;
    private Long sequenciaEndereco;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.codPessoa")
    private final List<ProtocoloEnderecoPessoa> enderecos = new ArrayList();
    @Column(name="cnpj_cpf")
    @Length(max=20)
    private @Length(max=20) String cnpjCpf;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;
    private LocalDate dataNascimento;

    public static ProtocoloPessoa ofPessoa(Long protocoloPessoa) {
        ProtocoloPessoa p = new ProtocoloPessoa();
        p.setPessoa(protocoloPessoa);
        return p;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getEndimovel() {
        return this.endimovel;
    }

    public void setEndimovel(String endimovel) {
        this.endimovel = endimovel;
    }

    public String getInscrimovel() {
        return this.inscrimovel;
    }

    public void setInscrimovel(String inscrimovel) {
        this.inscrimovel = inscrimovel;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public Long getSequenciaEndereco() {
        return this.sequenciaEndereco;
    }

    public void setSequenciaEndereco(Long sequenciaEndereco) {
        this.sequenciaEndereco = sequenciaEndereco;
    }

    public List<ProtocoloEnderecoPessoa> getEnderecos() {
        return this.enderecos;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public ProtocoloEnderecoPessoa getEnderecoPrincipal() {
        for (ProtocoloEnderecoPessoa protocoloEnderecoPessoa : this.enderecos) {
            if (protocoloEnderecoPessoa.getPk().getCodigo() == null || !protocoloEnderecoPessoa.getPk().getCodigo().equals(this.sequenciaEndereco)) continue;
            return protocoloEnderecoPessoa;
        }
        return null;
    }

    public void setEnderecoPrincipal(ProtocoloEnderecoPessoa protocoloEnderecoPessoa) {
        this.sequenciaEndereco = null;
        if (protocoloEnderecoPessoa != null) {
            this.sequenciaEndereco = protocoloEnderecoPessoa.getPk().getCodigo();
        }
    }

    public ProtocoloPessoa withCodigo(Long codigoProtocolo) {
        this.pessoa = codigoProtocolo;
        return this;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public Long getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    public Long getSequenciaCorrespondencia() {
        return this.sequenciaCorrespondencia;
    }

    public void setSequenciaCorrespondencia(Long sequenciaCorrespondencia) {
        this.sequenciaCorrespondencia = sequenciaCorrespondencia;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    @Generated
    public String toString() {
        return "ProtocoloPessoa(pessoa=" + this.getPessoa() + ", tipoPessoa=" + String.valueOf(this.getTipoPessoa()) + ", nome=" + this.getNome() + ")";
    }
}

