/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.protocolo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.protocolo.ProtocoloCidade;
import br.com.elotech.di.domain.protocolo.ProtocoloTipoLogradouro;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="protocolo.logradouro")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ProtocoloLogradouro
implements Replicable<Logradouro, Long> {
    @Id
    @EloSequence
    @Column(name="Logradouro")
    private Long codigo;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    private ProtocoloTipoLogradouro tipoLogradouro;
    @ManyToOne
    @NotNull
    private ProtocoloCidade cidade;
    private Long bairro = 0L;
    @Length(max=100)
    private @Length(max=100) String descricao;
    @Length(max=10)
    private @Length(max=10) String cep;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="bo_ativo")
    private Boolean ativo = Boolean.TRUE;
    private Long idUnico;

    public ProtocoloLogradouro() {
    }

    public ProtocoloLogradouro(Long codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public ProtocoloTipoLogradouro getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public ProtocoloLogradouro withCodigo(Long codigo) {
        this.setCodigo(codigo);
        return this;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public void setTipoLogradouro(ProtocoloTipoLogradouro tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public ProtocoloCidade getCidade() {
        return this.cidade;
    }

    public void setCidade(ProtocoloCidade cidade) {
        this.cidade = cidade;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public Long getBairro() {
        return this.bairro;
    }

    public void setBairro(Long bairro) {
        this.bairro = bairro;
    }

    @Generated
    public String toString() {
        return "ProtocoloLogradouro(codigo=" + this.getCodigo() + ", tipoLogradouro=" + String.valueOf(this.getTipoLogradouro()) + ", cidade=" + String.valueOf(this.getCidade()) + ", bairro=" + this.getBairro() + ", descricao=" + this.getDescricao() + ", cep=" + this.getCep() + ", ativo=" + this.getAtivo() + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocoloLogradouro)) {
            return false;
        }
        ProtocoloLogradouro other = (ProtocoloLogradouro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtocoloLogradouro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

