/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.protocolo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.protocolo.ProtocoloBairro;
import br.com.elotech.di.domain.protocolo.ProtocoloCidade;
import br.com.elotech.di.domain.protocolo.ProtocoloLogradouro;
import br.com.elotech.di.domain.protocolo.ProtocoloUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import java.util.Arrays;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="protocolo.entidade")
public class ProtocoloEntidade
implements EloEntity<Long>,
Replicable<Entidade, Long> {
    @Id
    @Column(name="entidade")
    @NotNull
    @EloSequence
    private Long id;
    @Column(length=100)
    @Length(max=100)
    private @Length(max=100) String nome;
    @Column(length=15)
    @Length(max=15)
    private @Length(max=15) String cnpj;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String cep;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    private ProtocoloEntidade entidadePrincipal;
    @Column(name="tipoEntidade")
    private EntidadeTipo tipo;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String identificacaoTCE;
    private byte[] brasao;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String telefone;
    @ManyToOne
    @NotFound
    @NotNull
    private ProtocoloUnidadeFederacao unidadefederacao;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String numero;
    @ManyToOne
    @NotFound
    @NotNull
    private ProtocoloLogradouro logradouro;
    @ManyToOne
    @NotFound
    @NotNull
    private ProtocoloBairro bairro;
    @ManyToOne
    @NotFound
    @NotNull
    private ProtocoloCidade cidade;
    @Column(name="clienteelotechsn")
    private Boolean clienteElotech;
    @Column(name="entidadeconsole")
    @Type(type="uuid-char")
    private UUID entidadeConsole;
    private Long idUnico;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    @Transient
    public Boolean isEntidadePrincipal() {
        return this.equals((Object)this.entidadePrincipal);
    }

    public static ProtocoloEntidade of(Long id) {
        ProtocoloEntidade entidade = new ProtocoloEntidade();
        entidade.setId(id);
        return entidade;
    }

    public ProtocoloEntidade withIdUnico(Long idUnico) {
        this.setIdUnico(idUnico);
        return this;
    }

    @Generated
    public String toString() {
        return "ProtocoloEntidade(id=" + this.getId() + ", nome=" + this.getNome() + ", cnpj=" + this.getCnpj() + ", cep=" + this.getCep() + ", tipo=" + String.valueOf(this.getTipo()) + ", identificacaoTCE=" + this.getIdentificacaoTCE() + ", brasao=" + Arrays.toString(this.getBrasao()) + ", telefone=" + this.getTelefone() + ", unidadefederacao=" + String.valueOf(this.getUnidadefederacao()) + ", numero=" + this.getNumero() + ", logradouro=" + String.valueOf(this.getLogradouro()) + ", bairro=" + String.valueOf(this.getBairro()) + ", cidade=" + String.valueOf(this.getCidade()) + ", clienteElotech=" + this.getClienteElotech() + ", entidadeConsole=" + String.valueOf(this.getEntidadeConsole()) + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocoloEntidade)) {
            return false;
        }
        ProtocoloEntidade other = (ProtocoloEntidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtocoloEntidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public ProtocoloEntidade getEntidadePrincipal() {
        return this.entidadePrincipal;
    }

    @Generated
    public EntidadeTipo getTipo() {
        return this.tipo;
    }

    @Generated
    public String getIdentificacaoTCE() {
        return this.identificacaoTCE;
    }

    @Generated
    public byte[] getBrasao() {
        return this.brasao;
    }

    @Generated
    public String getTelefone() {
        return this.telefone;
    }

    @Generated
    public ProtocoloUnidadeFederacao getUnidadefederacao() {
        return this.unidadefederacao;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public ProtocoloLogradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public ProtocoloBairro getBairro() {
        return this.bairro;
    }

    @Generated
    public ProtocoloCidade getCidade() {
        return this.cidade;
    }

    @Generated
    public Boolean getClienteElotech() {
        return this.clienteElotech;
    }

    @Generated
    public UUID getEntidadeConsole() {
        return this.entidadeConsole;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setEntidadePrincipal(ProtocoloEntidade entidadePrincipal) {
        this.entidadePrincipal = entidadePrincipal;
    }

    @Generated
    public void setTipo(EntidadeTipo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setIdentificacaoTCE(String identificacaoTCE) {
        this.identificacaoTCE = identificacaoTCE;
    }

    @Generated
    public void setBrasao(byte[] brasao) {
        this.brasao = brasao;
    }

    @Generated
    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Generated
    public void setUnidadefederacao(ProtocoloUnidadeFederacao unidadefederacao) {
        this.unidadefederacao = unidadefederacao;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setLogradouro(ProtocoloLogradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setBairro(ProtocoloBairro bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCidade(ProtocoloCidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setClienteElotech(Boolean clienteElotech) {
        this.clienteElotech = clienteElotech;
    }

    @Generated
    public void setEntidadeConsole(UUID entidadeConsole) {
        this.entidadeConsole = entidadeConsole;
    }
}

