/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.protocolo;

import br.com.elotech.core.converter.EnderecoTipoStringConverter;
import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.di.domain.protocolo.ProtocoloBairro;
import br.com.elotech.di.domain.protocolo.ProtocoloCidade;
import br.com.elotech.di.domain.protocolo.ProtocoloEnderecoPessoaPK;
import br.com.elotech.di.domain.protocolo.ProtocoloLogradouro;
import br.com.elotech.di.domain.protocolo.ProtocoloUnidadeFederacao;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="protocolo.enderecopessoa")
@DynamicInsert
@DynamicUpdate
public class ProtocoloEnderecoPessoa {
    @EmbeddedId
    @Valid
    private final ProtocoloEnderecoPessoaPK pk = new ProtocoloEnderecoPessoaPK();
    @Convert(converter=EnderecoTipoStringConverter.class)
    private EnderecoTipo tipoEndereco;
    @Length(max=100)
    private @Length(max=100) String endereco;
    @Length(max=10)
    private @Length(max=10) String numero;
    @Length(max=100)
    private @Length(max=100) String complemento;
    @Length(max=10)
    private @Length(max=10) String cep;
    @ManyToOne
    @JoinColumn
    @NotFound(action=NotFoundAction.IGNORE)
    private ProtocoloCidade cidade;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="logradouro")})
    @NotFound(action=NotFoundAction.IGNORE)
    private ProtocoloLogradouro logradouro;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="bairro")})
    @NotFound(action=NotFoundAction.IGNORE)
    private ProtocoloBairro bairro;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="unidadeFederacao")})
    @NotFound(action=NotFoundAction.IGNORE)
    private ProtocoloUnidadeFederacao uf;

    public ProtocoloEnderecoPessoaPK getPk() {
        return this.pk;
    }

    public EnderecoTipo getTipoEndereco() {
        return this.tipoEndereco;
    }

    public void setTipoEndereco(EnderecoTipo tipoEndereco) {
        this.tipoEndereco = tipoEndereco;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public ProtocoloUnidadeFederacao getUf() {
        return this.uf;
    }

    public void setUf(ProtocoloUnidadeFederacao uf) {
        this.uf = uf;
    }

    public void setCidade(ProtocoloCidade cidade) {
        this.cidade = cidade;
    }

    public void setLogradouro(ProtocoloLogradouro logradouro) {
        this.logradouro = logradouro;
    }

    public void setBairro(ProtocoloBairro bairro) {
        this.bairro = bairro;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getCep() {
        return this.cep;
    }

    public ProtocoloCidade getCidade() {
        return this.cidade;
    }

    public ProtocoloLogradouro getLogradouro() {
        return this.logradouro;
    }

    public ProtocoloBairro getBairro() {
        return this.bairro;
    }

    @Generated
    public String toString() {
        return "ProtocoloEnderecoPessoa(pk=" + String.valueOf(this.getPk()) + ", tipoEndereco=" + String.valueOf(this.getTipoEndereco()) + ", endereco=" + this.getEndereco() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cep=" + this.getCep() + ", cidade=" + String.valueOf(this.getCidade()) + ", logradouro=" + String.valueOf(this.getLogradouro()) + ", bairro=" + String.valueOf(this.getBairro()) + ", uf=" + String.valueOf(this.getUf()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocoloEnderecoPessoa)) {
            return false;
        }
        ProtocoloEnderecoPessoa other = (ProtocoloEnderecoPessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProtocoloEnderecoPessoaPK this$pk = this.getPk();
        ProtocoloEnderecoPessoaPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtocoloEnderecoPessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocoloEnderecoPessoaPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }
}

