/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.protocolo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.protocolo.ProtocoloUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="protocolo.cidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ProtocoloCidade
implements Replicable<Cidade, Long> {
    @Id
    @EloSequence
    @Column(name="cidade")
    private Long codigo;
    @NotNull
    @ManyToOne
    @JoinColumn(name="unidadefederacao")
    private ProtocoloUnidadeFederacao uf;
    @Length(max=100)
    private @Length(max=100) String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="bo_ativo")
    private Boolean ativo = Boolean.TRUE;
    private Long idUnico;

    public ProtocoloCidade() {
    }

    public ProtocoloCidade(Long codigo) {
        this.codigo = codigo;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public ProtocoloUnidadeFederacao getUf() {
        return this.uf;
    }

    public void setUf(ProtocoloUnidadeFederacao uf) {
        this.uf = uf;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public ProtocoloCidade withCodigo(Long codigo) {
        this.codigo = codigo;
        return this;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public String toString() {
        return "ProtocoloCidade(codigo=" + this.getCodigo() + ", uf=" + String.valueOf(this.getUf()) + ", descricao=" + this.getDescricao() + ", ativo=" + this.getAtivo() + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocoloCidade)) {
            return false;
        }
        ProtocoloCidade other = (ProtocoloCidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtocoloCidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

