/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.enums.functions;

import br.com.elotech.di.domain.enums.functions.DataTypeFunctions;
import br.com.elotech.di.exception.DataTypeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class DataHoraFunctions
implements DataTypeFunctions {
    private final DateTimeFormatter dataHoraToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public Object cast(String value) {
        if (Objects.isNull(value)) {
            return "";
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (ParseException e) {
            throw new DataTypeException((Throwable)e);
        }
    }

    public String toSql(Object o) {
        if (o instanceof LocalDateTime) {
            LocalDateTime date = (LocalDateTime)o;
            return this.overQuotes(date.format(this.dataHoraToStringFormatter));
        }
        return "";
    }

    private String overQuotes(String data) {
        return "'" + data + "'";
    }
}

