/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.enums.functions;

import br.com.elotech.di.domain.enums.functions.DataTypeFunctions;
import br.com.elotech.di.exception.DataTypeException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class DataFunctions
implements DataTypeFunctions {
    private final DateTimeFormatter dataToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public Object cast(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        catch (Exception e) {
            throw new DataTypeException((Throwable)e);
        }
    }

    public String toSql(Object o) {
        if (o instanceof LocalDate) {
            LocalDate date = (LocalDate)o;
            return this.overQuotes(date.format(this.dataToStringFormatter));
        }
        return "";
    }

    private String overQuotes(String data) {
        return "'" + data + "'";
    }
}

