/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.dto;

import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.domain.dto.GrupoDuplicado;
import br.com.elotech.di.domain.protocolo.ProtocoloPessoa;
import br.com.elotech.di.domain.siscop.SiscopFornecedor;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public class GrupoDuplicado {
    private Pessoa remaining;
    private List<Pessoa> pessoas;

    public GrupoDuplicado() {
    }

    public GrupoDuplicado(List<Pessoa> pessoas) {
        this.pessoas = this.sortedList(pessoas);
    }

    public Boolean isSimpleDuplication() {
        return this.countAiseDuplicates() <= 1L && this.countApiceDuplicates() <= 1L && this.countSiscopDuplicates() <= 1L && this.countProtocoloDuplicates() <= 1L;
    }

    public long countProtocoloDuplicates() {
        return this.count(Pessoa::getCodigoProtocolo);
    }

    public long countSiscopDuplicates() {
        return this.count(Pessoa::getCodigoSiscop);
    }

    public long countApiceDuplicates() {
        return this.count(Pessoa::getCodigoApice);
    }

    public long countAiseDuplicates() {
        return this.count(Pessoa::getCodigoAise);
    }

    private long count(Function<Pessoa, Long> function) {
        return this.pessoas.stream().map(function).filter(Objects::nonNull).count();
    }

    public boolean hasPessoal() {
        return this.pessoas.stream().anyMatch(Pessoa::getPessoal);
    }

    public boolean hasContribuinte() {
        return this.pessoas.stream().anyMatch(Pessoa::getContribuinte);
    }

    public boolean hasFornecedor() {
        return this.pessoas.stream().anyMatch(Pessoa::getFornecedor);
    }

    public boolean hasProtocolo() {
        return this.pessoas.stream().anyMatch(Pessoa::getProtocolo);
    }

    private List<Pessoa> sortedList(List<Pessoa> sourceList) {
        Comparator<Pessoa> comparator = Comparator.comparing(Pessoa::getPessoal).thenComparing(Pessoa::getContribuinte).thenComparing(Pessoa::getFornecedor).thenComparing(Pessoa::getProtocolo).reversed();
        return sourceList.stream().sorted(comparator).collect(Collectors.toList());
    }

    public List<Pessoa> getPessoasExcept(Pessoa remaining) {
        return this.pessoas.stream().filter(p -> !p.equals((Object)remaining)).collect(Collectors.toList());
    }

    public Pessoa chooseRemaining() {
        if (Objects.nonNull(this.remaining)) {
            return this.remaining;
        }
        return (Pessoa)this.pessoas.stream().findFirst().get();
    }

    public long countByClass(Class<?> clazz) {
        if (clazz.equals(AisePessoa.class)) {
            return this.countAiseDuplicates();
        }
        if (clazz.equals(SiscopFornecedor.class)) {
            return this.countSiscopDuplicates();
        }
        if (clazz.equals(ApicePessoa.class)) {
            return this.countApiceDuplicates();
        }
        if (clazz.equals(ProtocoloPessoa.class)) {
            return this.countProtocoloDuplicates();
        }
        throw new IllegalArgumentException();
    }

    @Generated
    public static GrupoDuplicadoBuilder builder() {
        return new GrupoDuplicadoBuilder();
    }

    @Generated
    public Pessoa getRemaining() {
        return this.remaining;
    }

    @Generated
    public List<Pessoa> getPessoas() {
        return this.pessoas;
    }

    @Generated
    public void setRemaining(Pessoa remaining) {
        this.remaining = remaining;
    }

    @Generated
    public void setPessoas(List<Pessoa> pessoas) {
        this.pessoas = pessoas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrupoDuplicado)) {
            return false;
        }
        GrupoDuplicado other = (GrupoDuplicado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Pessoa this$remaining = this.getRemaining();
        Pessoa other$remaining = other.getRemaining();
        if (this$remaining == null ? other$remaining != null : !this$remaining.equals(other$remaining)) {
            return false;
        }
        List this$pessoas = this.getPessoas();
        List other$pessoas = other.getPessoas();
        return !(this$pessoas == null ? other$pessoas != null : !((Object)this$pessoas).equals(other$pessoas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GrupoDuplicado;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pessoa $remaining = this.getRemaining();
        result = result * 59 + ($remaining == null ? 43 : $remaining.hashCode());
        List $pessoas = this.getPessoas();
        result = result * 59 + ($pessoas == null ? 43 : ((Object)$pessoas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GrupoDuplicado(remaining=" + String.valueOf(this.getRemaining()) + ", pessoas=" + String.valueOf(this.getPessoas()) + ")";
    }
}

