/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.datasource;

import br.com.elotech.di.domain.enums.Method;
import br.com.elotech.di.domain.query.APIQuery;
import br.com.elotech.di.domain.query.APIQueryExecutor;
import br.com.elotech.di.domain.query.AbstractQuery;
import br.com.elotech.di.domain.query.JDBCQuery;
import br.com.elotech.di.domain.query.JDBCQueryExecutor;
import br.com.elotech.di.domain.query.QueryResult;
import br.com.elotech.di.exception.QueryExecutionException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class QueryExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryExecutorFactory.class);
    private final APIQueryExecutor apiQueryExecutor;
    private final JDBCQueryExecutor jdbcQueryExecutor;

    public Page<List<QueryResult>> execute(AbstractQuery query, Pageable page) throws QueryExecutionException {
        if (query instanceof APIQuery) {
            return this.apiQueryExecutor.execute(query, page);
        }
        if (query instanceof JDBCQuery) {
            return this.jdbcQueryExecutor.execute(query, page);
        }
        throw new QueryExecutionException("N\u00e3o foi poss\u00edvel executar a query");
    }

    public Boolean testarHost(String host) {
        HttpURLConnection connection = this.apiQueryExecutor.getConnection(host, Method.GET);
        try {
            connection.connect();
        }
        catch (IOException e) {
            LOGGER.info(String.format("host invalido -> %s", host), (Throwable)e);
            return false;
        }
        return true;
    }

    public List<QueryResult> gerarCampos(AbstractQuery query) throws QueryExecutionException {
        if (query instanceof APIQuery) {
            return this.apiQueryExecutor.generateFields(query);
        }
        if (query instanceof JDBCQuery) {
            return this.jdbcQueryExecutor.generateFields(query);
        }
        throw new QueryExecutionException("N\u00e3o foi poss\u00edvel executar a query");
    }

    @Generated
    public QueryExecutorFactory(APIQueryExecutor apiQueryExecutor, JDBCQueryExecutor jdbcQueryExecutor) {
        this.apiQueryExecutor = apiQueryExecutor;
        this.jdbcQueryExecutor = jdbcQueryExecutor;
    }
}

