/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.apice.ApiceModulo;
import br.com.elotech.di.domain.apice.ApiceUsuario;
import br.com.elotech.di.domain.apice.ApiceUsuarioModuloPK;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="apice.usuariomodulo")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ApiceUsuarioModulo {
    @EmbeddedId
    @Valid
    private final ApiceUsuarioModuloPK pk = new ApiceUsuarioModuloPK();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean prioritario;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean novidades;

    public ApiceUsuarioModuloPK getPk() {
        return this.pk;
    }

    public Boolean getPrioritario() {
        return this.prioritario;
    }

    public void setPrioritario(Boolean prioritario) {
        this.prioritario = prioritario;
    }

    public Boolean getNovidades() {
        return this.novidades;
    }

    public void setNovidades(Boolean novidades) {
        this.novidades = novidades;
    }

    public static ApiceUsuarioModulo of(ApiceUsuario usuario, ApiceModulo modulo) {
        return new ApiceUsuarioModulo().withUsuario(usuario).withModulo(modulo);
    }

    public ApiceUsuarioModulo withModulo(ApiceModulo modulo) {
        this.pk.setModulo(modulo);
        return this;
    }

    public ApiceUsuarioModulo withUsuario(ApiceUsuario usuario) {
        this.pk.setUsuario(usuario);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiceUsuarioModulo)) {
            return false;
        }
        ApiceUsuarioModulo other = (ApiceUsuarioModulo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ApiceUsuarioModuloPK this$pk = this.getPk();
        ApiceUsuarioModuloPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiceUsuarioModulo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiceUsuarioModuloPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiceUsuarioModulo(pk=" + String.valueOf(this.getPk()) + ", prioritario=" + this.getPrioritario() + ", novidades=" + this.getNovidades() + ")";
    }
}

