/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.apice.ApiceEntidade;
import br.com.elotech.di.domain.apice.ApiceUsuario;
import br.com.elotech.di.domain.apice.ApiceUsuarioEntidadePK;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="apice.usuarioentidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ApiceUsuarioEntidade {
    @EmbeddedId
    @Valid
    private final ApiceUsuarioEntidadePK pk = new ApiceUsuarioEntidadePK();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean padrao;

    public Boolean getPadrao() {
        return this.padrao;
    }

    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    public ApiceUsuarioEntidadePK getPk() {
        return this.pk;
    }

    public static ApiceUsuarioEntidade of(ApiceUsuario usuario, ApiceEntidade entidade) {
        return new ApiceUsuarioEntidade().withUsuario(usuario).withEntidade(entidade);
    }

    public ApiceUsuarioEntidade withEntidade(ApiceEntidade entidade) {
        this.pk.setEntidade(entidade);
        return this;
    }

    public ApiceUsuarioEntidade withUsuario(ApiceUsuario usuario) {
        this.pk.setUsuario(usuario);
        return this;
    }

    public ApiceUsuarioEntidade withPadrao(Boolean padrao) {
        this.setPadrao(padrao);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiceUsuarioEntidade)) {
            return false;
        }
        ApiceUsuarioEntidade other = (ApiceUsuarioEntidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ApiceUsuarioEntidadePK this$pk = this.getPk();
        ApiceUsuarioEntidadePK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiceUsuarioEntidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiceUsuarioEntidadePK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiceUsuarioEntidade(pk=" + String.valueOf(this.getPk()) + ", padrao=" + this.getPadrao() + ")";
    }
}

