/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.apice.ApiceNivelUsuario;
import br.com.elotech.di.domain.apice.ApiceUsuarioEntidade;
import br.com.elotech.di.domain.apice.ApiceUsuarioModulo;
import br.com.elotech.di.domain.apice.ApiceUsuarioSubNivel;
import br.com.elotech.di.replicate.support.Replicable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="apice.usuario")
@DynamicInsert
@DynamicUpdate
public class ApiceUsuario
implements Replicable<Usuario, Long> {
    @Id
    @EloSequence
    @Column(name="usuario")
    @Length(max=250)
    private @Length(max=250) String id;
    @Length(max=150)
    private @Length(max=150) String nome;
    @Length(max=15)
    private @Length(max=15) String senha;
    @ManyToOne
    private ApiceNivelUsuario nivelUsuario;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo = Boolean.TRUE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean publicidade = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean aprovaSolicitacao;
    @Length(max=20)
    private @Length(max=20) String cpf;
    @Length(max=20)
    private @Length(max=20) String rg;
    @Length(max=20)
    private @Length(max=20) String orgaoEmissor;
    @Length(max=60)
    private @Length(max=60) String descricaoCargo;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean acessaRel;
    @Length(max=30)
    private @Length(max=30) String matricula;
    private ApiceUsuarioSubNivel subNivel;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean arquivoAnexo;
    @Length(max=100)
    private @Length(max=100) String lotacao;
    private Long idUnico;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.usuario")
    @Valid
    private final Set<ApiceUsuarioEntidade> entidades = new HashSet();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.usuario")
    @Valid
    private final Set<ApiceUsuarioModulo> modulos = new HashSet();

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    public String getDescricaoCargo() {
        return this.descricaoCargo;
    }

    public void setDescricaoCargo(String descricaoCargo) {
        this.descricaoCargo = descricaoCargo;
    }

    public String getMatricula() {
        return this.matricula;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    public String getLotacao() {
        return this.lotacao;
    }

    public void setLotacao(String lotacao) {
        this.lotacao = lotacao;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public Boolean getPublicidade() {
        return this.publicidade;
    }

    public void setPublicidade(Boolean publicidade) {
        this.publicidade = publicidade;
    }

    public Boolean getAprovaSolicitacao() {
        return this.aprovaSolicitacao;
    }

    public void setAprovaSolicitacao(Boolean aprovaSolicitacao) {
        this.aprovaSolicitacao = aprovaSolicitacao;
    }

    public Boolean getAcessaRel() {
        return this.acessaRel;
    }

    public void setAcessaRel(Boolean acessaRel) {
        this.acessaRel = acessaRel;
    }

    public Boolean getArquivoAnexo() {
        return this.arquivoAnexo;
    }

    public void setArquivoAnexo(Boolean arquivoAnexo) {
        this.arquivoAnexo = arquivoAnexo;
    }

    public ApiceNivelUsuario getNivelUsuario() {
        return this.nivelUsuario;
    }

    public void setNivelUsuario(ApiceNivelUsuario nivelUsuario) {
        this.nivelUsuario = nivelUsuario;
    }

    public ApiceUsuarioSubNivel getSubNivel() {
        return this.subNivel;
    }

    public void setSubNivel(ApiceUsuarioSubNivel subNivel) {
        this.subNivel = subNivel;
    }

    public Set<ApiceUsuarioEntidade> getEntidades() {
        return this.entidades;
    }

    public Set<ApiceUsuarioModulo> getModulos() {
        return this.modulos;
    }

    public ApiceUsuario withSenha(String senha) {
        this.setSenha(senha);
        return this;
    }

    public ApiceUsuario withAtivo(Boolean ativo) {
        this.setAtivo(ativo);
        return this;
    }

    @Generated
    public String toString() {
        return "ApiceUsuario(id=" + this.getId() + ", nome=" + this.getNome() + ", cpf=" + this.getCpf() + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiceUsuario)) {
            return false;
        }
        ApiceUsuario other = (ApiceUsuario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiceUsuario;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

