/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.di.domain.TipoDocumento;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ApiceTipoDocumento {
    INSS("INSS", TipoDocumento.INSS),
    FGTS("FGTS", TipoDocumento.FGTS),
    FEDERAL("Federal", TipoDocumento.FEDERAL),
    ESTADUAL("Estadual", TipoDocumento.ESTADUAL),
    MUNICIPAL("Municipal", TipoDocumento.MUNICIPAL),
    OUTROS("Outros", TipoDocumento.OUTROS),
    TCE("TCE", TipoDocumento.TCE),
    CREA("CREA", TipoDocumento.CREA),
    CNDT("CNDT", TipoDocumento.CNDT);

    private final String codigo;
    private final TipoDocumento tipoDocumento;
    private static final Map<TipoDocumento, ApiceTipoDocumento> TO_APICE_TIPO_DOCUMENTO;

    public TipoDocumento getTipoDocumento() {
        return this.tipoDocumento;
    }

    public static ApiceTipoDocumento getApiceTipoDocumento(TipoDocumento tipoDocumento) {
        ApiceTipoDocumento tipo = (ApiceTipoDocumento)TO_APICE_TIPO_DOCUMENTO.get(tipoDocumento);
        if (tipo == null) {
            return OUTROS;
        }
        return tipo;
    }

    @JsonCreator
    public static ApiceTipoDocumento getTipoDocumento(String codigo) {
        for (ApiceTipoDocumento tipoDocumento : ApiceTipoDocumento.values()) {
            if (!tipoDocumento.codigo.equals(codigo)) continue;
            return tipoDocumento;
        }
        throw new IllegalArgumentException();
    }

    private ApiceTipoDocumento(String codigo, TipoDocumento tipoDocumento) {
        this.codigo = codigo;
        this.tipoDocumento = tipoDocumento;
    }

    public String getCodigo() {
        return this.codigo;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ApiceTipoDocumento apiceTipoDocumento : ApiceTipoDocumento.values()) {
            builder.put((Object)apiceTipoDocumento.tipoDocumento, (Object)apiceTipoDocumento);
        }
        TO_APICE_TIPO_DOCUMENTO = builder.build();
    }
}

