/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.di.domain.apice.ApiceArquivo;
import br.com.elotech.di.domain.apice.ApiceDocumentacao;
import br.com.elotech.di.domain.shared.Arquivo;
import java.time.LocalDate;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="apice.pessoadocumentacao")
@DynamicInsert
@DynamicUpdate
public class ApicePessoaDocumentacao {
    @Id
    @EloSequence(applyOnMerge=true, schema="apice", sequenceName="SPKPESSOADOC")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    private ApiceDocumentacao documentacao;
    @NotNull
    private LocalDate dataEmissaoDocumento;
    @Length(max=50)
    private @Length(max=50) String numeroDocumento;
    private LocalDate validadeDocumento;
    private LocalDate dataInclusao;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="idarquivo")
    private ApiceArquivo arquivo;

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public LocalDate getValidadeDocumento() {
        return this.validadeDocumento;
    }

    public void setValidadeDocumento(LocalDate validadeDocumento) {
        this.validadeDocumento = validadeDocumento;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ApiceDocumentacao getDocumentacao() {
        return this.documentacao;
    }

    public void setDocumentacao(ApiceDocumentacao documentacao) {
        this.documentacao = documentacao;
    }

    public LocalDate getDataEmissaoDocumento() {
        return this.dataEmissaoDocumento;
    }

    public void setDataEmissaoDocumento(LocalDate dataEmissaoDocumento) {
        this.dataEmissaoDocumento = dataEmissaoDocumento;
    }

    public Arquivo getArquivo() {
        if (this.arquivo == null) {
            return null;
        }
        return this.arquivo.getArquivo();
    }

    public void setArquivo(ApiceArquivo arquivo) {
        this.arquivo = arquivo;
    }

    @Generated
    public String toString() {
        return "ApicePessoaDocumentacao(id=" + this.getId() + ", documentacao=" + String.valueOf(this.getDocumentacao()) + ", dataEmissaoDocumento=" + String.valueOf(this.getDataEmissaoDocumento()) + ", numeroDocumento=" + this.getNumeroDocumento() + ", validadeDocumento=" + String.valueOf(this.getValidadeDocumento()) + ", dataInclusao=" + String.valueOf(this.getDataInclusao()) + ", arquivo=" + String.valueOf(this.getArquivo()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApicePessoaDocumentacao)) {
            return false;
        }
        ApicePessoaDocumentacao other = (ApicePessoaDocumentacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApicePessoaDocumentacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

