/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToLongConverter;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.converter.TipoPessoaEnumConverter;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.converter.PessoaEscolaridadeStringConverter;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaSituacao;
import br.com.elotech.di.domain.apice.ApiceBancoPessoa;
import br.com.elotech.di.domain.apice.ApiceCnae;
import br.com.elotech.di.domain.apice.ApiceContatoPessoa;
import br.com.elotech.di.domain.apice.ApiceEnderecoPessoa;
import br.com.elotech.di.domain.apice.ApicePessoaAlteraRazao;
import br.com.elotech.di.domain.apice.ApicePessoaDocumentacao;
import br.com.elotech.di.domain.apice.ApicePessoaSocio;
import br.com.elotech.di.domain.apice.ApiceRamoAtividade;
import br.com.elotech.di.domain.apice.ApiceUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.unico.client.domain.enums.PessoaEscolaridade;
import br.com.elotech.unico.client.domain.enums.PessoaTipoEmpresa;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="apice.pessoa")
@DynamicInsert
@DynamicUpdate
public class ApicePessoa
implements Replicable<Pessoa, Long>,
Serializable {
    @Id
    @EloSequence
    private Long pessoa;
    @Convert(converter=TipoPessoaEnumConverter.class)
    private TipoPessoa tipoPessoa;
    @Length(max=150)
    private @Length(max=150) String nome;
    @Length(max=150)
    private @Length(max=150) String nomeFantasia;
    @Column(name="cnpj_Cpf")
    @Length(max=20)
    private @Length(max=20) String cnpjCpf;
    @Length(max=20)
    private @Length(max=20) String rg;
    @Length(max=20)
    private @Length(max=20) String orgaoEmissor;
    private LocalDate dataEmissao;
    @Length(max=20)
    private @Length(max=20) String inscricaoEstadual;
    private Long sequenciaEndereco;
    private Long sequenciaContato;
    private Long sequenciaBanco;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean contribuinte = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean fornecedor;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean pessoal = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    private ApiceUnidadeFederacao estadoEmissor;
    private Integer modulo;
    @Length(max=250)
    private @Length(max=250) String usuario;
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    private Long banco;
    @Length(max=10)
    private @Length(max=10) String agencia;
    @Length(max=25)
    private @Length(max=25) String conta;
    @Length(max=50)
    private @Length(max=50) String cargo;
    @Length(max=20)
    private @Length(max=20) String matricula;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="micropequena")
    private Boolean microEmpresa;
    private LocalDate dataAlteracao;
    private LocalDate dataCadastro;
    private LocalDate dataInclusao;
    private PessoaTipoEmpresa tipoEmpresa;
    @Length(max=20)
    private @Length(max=20) String foneComercial;
    @Length(max=20)
    private @Length(max=20) String foneFax;
    @Length(max=100)
    private @Length(max=100) String email;
    @Length(max=100)
    private @Length(max=100) String homepage;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean folhaPagamento;
    private PessoaSituacao situacao;
    private Integer tipoMicro;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean optanteSimples;
    @Length(max=20)
    private @Length(max=20) String pis;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    private ApiceCnae cnae;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean consorcio;
    private BigDecimal percentual;
    @Column(name="datainisuspensao")
    private LocalDate dataIniSuspensao;
    @Column(name="datafinsuspensao")
    private LocalDate dataFimSuspensao;
    @Length(max=15)
    private @Length(max=15) String oab;
    @Length(max=15)
    private @Length(max=15) String crea;
    @Length(max=15)
    private @Length(max=15) String cau;
    @Convert(converter=BooleanToLongConverter.class)
    private Boolean estrangeiro = Boolean.FALSE;
    @Length(max=20)
    private @Length(max=20) String inscricaoMunicipal;
    @Convert(converter=PessoaEscolaridadeStringConverter.class)
    private PessoaEscolaridade escolaridade;
    private Long idUnico;
    @Caption(value="Capital social")
    private Double capitalsocial;
    @Caption(value="Data capital social")
    private LocalDate datacapitalsocial;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<ApiceBancoPessoa> bancos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<ApiceContatoPessoa> contatos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<ApiceEnderecoPessoa> enderecos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    private final List<ApicePessoaDocumentacao> documentos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<ApicePessoaSocio> socios = new ArrayList();
    @OneToMany
    @JoinTable(name="apice.pessoaramoatividade", joinColumns={@JoinColumn(name="pessoa", referencedColumnName="pessoa")}, inverseJoinColumns={@JoinColumn(name="ramoAtividade", referencedColumnName="ramoatividade")})
    private final Set<ApiceRamoAtividade> ramoAtividades = new HashSet();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<ApicePessoaAlteraRazao> alteracoesRazao = new ArrayList();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean empresaRegional = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean agricultorFamiliar = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="inabilitadocontratosfuturos")
    private Boolean inabilitadoContratosFuturos = Boolean.FALSE;

    public static ApicePessoa ofPessoa(Long apicePessoa) {
        ApicePessoa pessoaNew = new ApicePessoa();
        pessoaNew.setPessoa(apicePessoa);
        return pessoaNew;
    }

    public Set<ApiceRamoAtividade> getRamoAtividades() {
        return this.ramoAtividades;
    }

    public List<ApicePessoaAlteraRazao> getAlteracoesRazao() {
        return this.alteracoesRazao;
    }

    public Long getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public ApiceEnderecoPessoa getEnderecoPrincipal() {
        for (ApiceEnderecoPessoa apiceEnderecoPessoa : this.enderecos) {
            if (apiceEnderecoPessoa.getPk().getCodigo() == null || !apiceEnderecoPessoa.getPk().getCodigo().equals(this.sequenciaEndereco)) continue;
            return apiceEnderecoPessoa;
        }
        return null;
    }

    public void setEnderecoPrincipal(ApiceEnderecoPessoa apiceEnderecoPessoa) {
        this.sequenciaEndereco = null;
        if (apiceEnderecoPessoa != null) {
            this.sequenciaEndereco = apiceEnderecoPessoa.getPk().getCodigo();
        }
    }

    public ApiceContatoPessoa getContatoPrincipal() {
        for (ApiceContatoPessoa apiceContatoPessoa : this.contatos) {
            if (apiceContatoPessoa.getPk().getCodigo() == null || !apiceContatoPessoa.getPk().getCodigo().equals(this.sequenciaContato)) continue;
            return apiceContatoPessoa;
        }
        return null;
    }

    public void setContatoPrincipal(ApiceContatoPessoa apiceContatoPessoa) {
        this.sequenciaContato = null;
        if (apiceContatoPessoa != null) {
            this.sequenciaContato = apiceContatoPessoa.getPk().getCodigo();
        }
    }

    public ApiceBancoPessoa getContaBancariaPrincipal() {
        for (ApiceBancoPessoa apiceBancoPessoa : this.bancos) {
            if (apiceBancoPessoa.getPk().getCodigo() == null || !apiceBancoPessoa.getPk().getCodigo().equals(this.sequenciaBanco)) continue;
            return apiceBancoPessoa;
        }
        return null;
    }

    public void setContaBancariaPrincipal(ApiceBancoPessoa apiceBancoPessoa) {
        this.sequenciaBanco = null;
        if (apiceBancoPessoa != null) {
            this.sequenciaBanco = apiceBancoPessoa.getPk().getCodigo();
        }
    }

    public Long getSequenciaContato() {
        return this.sequenciaContato;
    }

    public void setSequenciaContato(Long sequenciaContato) {
        this.sequenciaContato = sequenciaContato;
    }

    public Long getSequenciaBanco() {
        return this.sequenciaBanco;
    }

    public void setSequenciaBanco(Long sequenciaBanco) {
        this.sequenciaBanco = sequenciaBanco;
    }

    public Boolean getContribuinte() {
        return this.contribuinte;
    }

    public void setContribuinte(Boolean contribuinte) {
        this.contribuinte = contribuinte;
    }

    public Boolean getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Boolean fornecedor) {
        this.fornecedor = fornecedor;
    }

    public Boolean getPessoal() {
        return this.pessoal;
    }

    public void setPessoal(Boolean pessoal) {
        this.pessoal = pessoal;
    }

    public ApiceUnidadeFederacao getEstadoEmissor() {
        return this.estadoEmissor;
    }

    public void setEstadoEmissor(ApiceUnidadeFederacao estadoEmissor) {
        this.estadoEmissor = estadoEmissor;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public Integer getModulo() {
        return this.modulo;
    }

    public void setModulo(Integer modulo) {
        this.modulo = modulo;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Long getBanco() {
        return this.banco;
    }

    public void setBanco(Long banco) {
        this.banco = banco;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getMatricula() {
        return this.matricula;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = microEmpresa;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public PessoaTipoEmpresa getTipoEmpresa() {
        return this.tipoEmpresa;
    }

    public void setTipoEmpresa(PessoaTipoEmpresa tipoEmpresa) {
        this.tipoEmpresa = tipoEmpresa;
    }

    public String getFoneComercial() {
        return this.foneComercial;
    }

    public void setFoneComercial(String foneComercial) {
        this.foneComercial = foneComercial;
    }

    public String getFoneFax() {
        return this.foneFax;
    }

    public void setFoneFax(String foneFax) {
        this.foneFax = foneFax;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public Boolean getFolhaPagamento() {
        return this.folhaPagamento;
    }

    public void setFolhaPagamento(Boolean folhaPagamento) {
        this.folhaPagamento = folhaPagamento;
    }

    public PessoaSituacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(PessoaSituacao situacao) {
        this.situacao = situacao;
    }

    public Integer getTipoMicro() {
        return this.tipoMicro;
    }

    public void setTipoMicro(Integer tipoMicro) {
        this.tipoMicro = tipoMicro;
    }

    public Boolean getOptanteSimples() {
        return this.optanteSimples;
    }

    public void setOptanteSimples(Boolean optanteSimples) {
        this.optanteSimples = optanteSimples;
    }

    public String getPis() {
        return this.pis;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public ApiceCnae getCnae() {
        return this.cnae;
    }

    public void setCnae(ApiceCnae cnae) {
        this.cnae = cnae;
    }

    public Boolean getConsorcio() {
        return this.consorcio;
    }

    public void setConsorcio(Boolean consorcio) {
        this.consorcio = consorcio;
    }

    public BigDecimal getPercentual() {
        return this.percentual;
    }

    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    public LocalDate getDataIniSuspensao() {
        return this.dataIniSuspensao;
    }

    public void setDataIniSuspensao(LocalDate dataIniSuspensao) {
        this.dataIniSuspensao = dataIniSuspensao;
    }

    public LocalDate getDataFimSuspensao() {
        return this.dataFimSuspensao;
    }

    public void setDataFimSuspensao(LocalDate dataFimSuspensao) {
        this.dataFimSuspensao = dataFimSuspensao;
    }

    public String getOab() {
        return this.oab;
    }

    public void setOab(String oab) {
        this.oab = oab;
    }

    public String getCrea() {
        return this.crea;
    }

    public void setCrea(String crea) {
        this.crea = crea;
    }

    public String getCau() {
        return this.cau;
    }

    public void setCau(String cau) {
        this.cau = cau;
    }

    public Boolean getEstrangeiro() {
        return this.estrangeiro;
    }

    public void setEstrangeiro(Boolean estrangeiro) {
        this.estrangeiro = estrangeiro;
    }

    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    public void setInscricaoMunicipal(String inscricaoMunicipal) {
        this.inscricaoMunicipal = inscricaoMunicipal;
    }

    public PessoaEscolaridade getEscolaridade() {
        return this.escolaridade;
    }

    public void setEscolaridade(PessoaEscolaridade escolaridade) {
        this.escolaridade = escolaridade;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public List<ApiceBancoPessoa> getBancos() {
        return this.bancos;
    }

    public List<ApiceContatoPessoa> getContatos() {
        return this.contatos;
    }

    public List<ApiceEnderecoPessoa> getEnderecos() {
        return this.enderecos;
    }

    public List<ApicePessoaDocumentacao> getDocumentos() {
        return this.documentos;
    }

    public List<ApicePessoaSocio> getSocios() {
        return this.socios;
    }

    public Boolean getEmpresaRegional() {
        return this.empresaRegional;
    }

    public void setEmpresaRegional(Boolean empresaRegional) {
        this.empresaRegional = empresaRegional;
    }

    public Boolean getAgricultorFamiliar() {
        return this.agricultorFamiliar;
    }

    public Boolean getInabilitadoContratosFuturos() {
        return this.inabilitadoContratosFuturos;
    }

    public void setAgricultorFamiliar(Boolean agricultorFamiliar) {
        this.agricultorFamiliar = agricultorFamiliar;
    }

    public void setInabilitadoContratosFuturos(Boolean inabilitadoContratosFuturos) {
        this.inabilitadoContratosFuturos = inabilitadoContratosFuturos;
    }

    public static ApicePessoa of(Long idUnico) {
        ApicePessoa pessoaNew = new ApicePessoa();
        pessoaNew.setIdUnico(idUnico);
        return pessoaNew;
    }

    public Double getcapitalsocial() {
        return this.capitalsocial;
    }

    public void setcapitalsocial(Double capitalsocial) {
        this.capitalsocial = capitalsocial;
    }

    public LocalDate getDatacapitalsocial() {
        return this.datacapitalsocial;
    }

    public void setDatacapitalsocial(LocalDate datacapitalsocial) {
        this.datacapitalsocial = datacapitalsocial;
    }

    @Generated
    public String toString() {
        return "ApicePessoa(pessoa=" + this.getPessoa() + ", nome=" + this.getNome() + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApicePessoa)) {
            return false;
        }
        ApicePessoa other = (ApicePessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        return !(this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApicePessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        return result;
    }
}

