/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.apice.ApiceLogradouroPK;
import br.com.elotech.di.domain.apice.ApiceTipoLogradouro;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="apice.logradouro")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ApiceLogradouro
implements Replicable<Logradouro, Long> {
    @EmbeddedId
    @Valid
    private ApiceLogradouroPK pk;
    @ManyToOne
    private ApiceTipoLogradouro tipoLogradouro;
    @Length(max=100)
    private @Length(max=100) String descricao;
    private Long idUnico;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;

    public ApiceLogradouro() {
    }

    public ApiceLogradouro(ApiceLogradouroPK pk) {
        this.pk = pk;
    }

    public ApiceLogradouroPK getPk() {
        return this.pk;
    }

    public void setPk(ApiceLogradouroPK pk) {
        this.pk = pk;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public ApiceTipoLogradouro getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public void setTipoLogradouro(ApiceTipoLogradouro tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public Boolean getAtivo() {
        return Boolean.TRUE.equals(this.ativo);
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public ApiceLogradouro withPk(ApiceLogradouroPK apiceLogradouroPK) {
        this.setPk(apiceLogradouroPK);
        return this;
    }

    @Generated
    public String toString() {
        return "ApiceLogradouro(pk=" + String.valueOf(this.getPk()) + ", tipoLogradouro=" + String.valueOf(this.getTipoLogradouro()) + ", descricao=" + this.getDescricao() + ", idUnico=" + this.getIdUnico() + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiceLogradouro)) {
            return false;
        }
        ApiceLogradouro other = (ApiceLogradouro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ApiceLogradouroPK this$pk = this.getPk();
        ApiceLogradouroPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiceLogradouro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiceLogradouroPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }
}

