/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.converter.EnderecoTipoStringConverter;
import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.di.domain.apice.ApiceBairro;
import br.com.elotech.di.domain.apice.ApiceCidade;
import br.com.elotech.di.domain.apice.ApiceEnderecoPessoaPK;
import br.com.elotech.di.domain.apice.ApiceLogradouro;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="apice.enderecopessoa")
@DynamicInsert
@DynamicUpdate
public class ApiceEnderecoPessoa {
    @EmbeddedId
    @Valid
    private final ApiceEnderecoPessoaPK pk = new ApiceEnderecoPessoaPK();
    @Convert(converter=EnderecoTipoStringConverter.class)
    private EnderecoTipo tipoEndereco;
    @Length(max=1)
    private @Length(max=1) String domicilioFiscalEstabelecido;
    @Length(max=10)
    private @Length(max=10) String numero;
    @Length(max=100)
    private @Length(max=100) String complemento;
    @Length(max=15)
    private @Length(max=15) String caixaPostal;
    @ManyToOne
    @JoinColumn
    @NotNull
    private ApiceCidade cidade;
    @Length(max=2)
    private @Length(max=2) String estado;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="cidade", referencedColumnName="cidade")), @JoinColumnOrFormula(column=@JoinColumn(name="logradouro", referencedColumnName="logradouro"))})
    @NotNull
    private ApiceLogradouro logradouro;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="cidade", referencedColumnName="cidade")), @JoinColumnOrFormula(column=@JoinColumn(name="bairro", referencedColumnName="bairro"))})
    @NotNull
    private ApiceBairro bairro;
    @Length(max=10)
    private @Length(max=10) String cep;

    public ApiceEnderecoPessoaPK getPk() {
        return this.pk;
    }

    public EnderecoTipo getTipoEndereco() {
        return this.tipoEndereco;
    }

    public void setTipoEndereco(EnderecoTipo tipoEndereco) {
        this.tipoEndereco = tipoEndereco;
    }

    public String getDomicilioFiscalEstabelecido() {
        return this.domicilioFiscalEstabelecido;
    }

    public void setDomicilioFiscalEstabelecido(String domicilioFiscalEstabelecido) {
        this.domicilioFiscalEstabelecido = domicilioFiscalEstabelecido;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getCaixaPostal() {
        return this.caixaPostal;
    }

    public void setCaixaPostal(String caixaPostal) {
        this.caixaPostal = caixaPostal;
    }

    public String getEstado() {
        return this.estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public ApiceLogradouro getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(ApiceLogradouro logradouro) {
        this.logradouro = logradouro;
    }

    public ApiceBairro getBairro() {
        return this.bairro;
    }

    public void setBairro(ApiceBairro bairro) {
        this.bairro = bairro;
    }

    public ApiceCidade getCidade() {
        return this.cidade;
    }

    public void setCidade(ApiceCidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public String toString() {
        return "ApiceEnderecoPessoa(pk=" + String.valueOf(this.getPk()) + ", tipoEndereco=" + String.valueOf(this.getTipoEndereco()) + ", domicilioFiscalEstabelecido=" + this.getDomicilioFiscalEstabelecido() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", caixaPostal=" + this.getCaixaPostal() + ", cidade=" + String.valueOf(this.getCidade()) + ", estado=" + this.getEstado() + ", logradouro=" + String.valueOf(this.getLogradouro()) + ", bairro=" + String.valueOf(this.getBairro()) + ", cep=" + this.getCep() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiceEnderecoPessoa)) {
            return false;
        }
        ApiceEnderecoPessoa other = (ApiceEnderecoPessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ApiceEnderecoPessoaPK this$pk = this.getPk();
        ApiceEnderecoPessoaPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiceEnderecoPessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiceEnderecoPessoaPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }
}

