/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.apice.ApiceUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="apice.cidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ApiceCidade
implements Replicable<Cidade, Long> {
    @Id
    @EloSequence
    @Column(name="cidade")
    private Long codigo;
    @NotNull
    @ManyToOne
    @JoinColumn(name="unidadefederacao")
    private ApiceUnidadeFederacao uf;
    @Length(max=100)
    private @Length(max=100) String descricao;
    @Length(max=10)
    private @Length(max=10) String ibge;
    @Length(max=10)
    private @Length(max=10) String codAplic;
    private Long idUnico;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;

    public ApiceCidade() {
    }

    public ApiceCidade(Long codigo) {
        this.codigo = codigo;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public ApiceUnidadeFederacao getUf() {
        return this.uf;
    }

    public void setUf(ApiceUnidadeFederacao uf) {
        this.uf = uf;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getIbge() {
        return this.ibge;
    }

    public void setIbge(String ibge) {
        this.ibge = ibge;
    }

    public String getCodAplic() {
        return this.codAplic;
    }

    public void setCodAplic(String codaAlic) {
        this.codAplic = codaAlic;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Boolean getAtivo() {
        return Boolean.TRUE.equals(this.ativo);
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public ApiceCidade withCodigo(Long codigo) {
        this.codigo = codigo;
        return this;
    }

    @Generated
    public String toString() {
        return "ApiceCidade(codigo=" + this.getCodigo() + ", uf=" + String.valueOf(this.getUf()) + ", descricao=" + this.getDescricao() + ", ibge=" + this.getIbge() + ", codAplic=" + this.getCodAplic() + ", idUnico=" + this.getIdUnico() + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiceCidade)) {
            return false;
        }
        ApiceCidade other = (ApiceCidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiceCidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

