/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.apice;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.apice.ApiceBairroPK;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="apice.bairro")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class ApiceBairro
implements Replicable<Bairro, Long> {
    @EmbeddedId
    @Valid
    private ApiceBairroPK pk;
    @Length(max=100)
    private @Length(max=100) String descricao;
    private Long idUnico;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;

    public ApiceBairro() {
    }

    public ApiceBairro(ApiceBairroPK pk) {
        this.pk = pk;
    }

    public ApiceBairroPK getPk() {
        return this.pk;
    }

    public void setPk(ApiceBairroPK pk) {
        this.pk = pk;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public Boolean getAtivo() {
        return Boolean.TRUE.equals(this.ativo);
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public ApiceBairro withPk(ApiceBairroPK apiceBairroPK) {
        this.setPk(apiceBairroPK);
        return this;
    }

    @Generated
    public String toString() {
        return "ApiceBairro(pk=" + String.valueOf(this.getPk()) + ", descricao=" + this.getDescricao() + ", idUnico=" + this.getIdUnico() + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiceBairro)) {
            return false;
        }
        ApiceBairro other = (ApiceBairro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ApiceBairroPK this$pk = this.getPk();
        ApiceBairroPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiceBairro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiceBairroPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }
}

