/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.aise.AiseModulo;
import br.com.elotech.di.domain.aise.AiseUsuario;
import br.com.elotech.di.domain.aise.AiseUsuarioModuloPK;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="aise.usuariomodulo")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class AiseUsuarioModulo {
    @EmbeddedId
    @Valid
    private final AiseUsuarioModuloPK pk = new AiseUsuarioModuloPK();
    @Column(length=2)
    @Length(max=2)
    private @Length(max=2) String ultimoAcesso;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean novidades;

    public AiseUsuarioModuloPK getPk() {
        return this.pk;
    }

    public String getUltimoAcesso() {
        return this.ultimoAcesso;
    }

    public void setUltimoAcesso(String ultimoAcesso) {
        this.ultimoAcesso = ultimoAcesso;
    }

    public Boolean getNovidades() {
        return this.novidades;
    }

    public void setNovidades(Boolean novidades) {
        this.novidades = novidades;
    }

    public static AiseUsuarioModulo of(AiseUsuario usuario, AiseModulo modulo) {
        return new AiseUsuarioModulo().withUsuario(usuario).withModulo(modulo);
    }

    public AiseUsuarioModulo withModulo(AiseModulo modulo) {
        this.pk.setModulo(modulo);
        return this;
    }

    public AiseUsuarioModulo withUsuario(AiseUsuario usuario) {
        this.pk.setUsuario(usuario);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseUsuarioModulo)) {
            return false;
        }
        AiseUsuarioModulo other = (AiseUsuarioModulo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AiseUsuarioModuloPK this$pk = this.getPk();
        AiseUsuarioModuloPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseUsuarioModulo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AiseUsuarioModuloPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AiseUsuarioModulo(pk=" + String.valueOf(this.getPk()) + ", ultimoAcesso=" + this.getUltimoAcesso() + ", novidades=" + this.getNovidades() + ")";
    }
}

