/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.aise.AiseEntidade;
import br.com.elotech.di.domain.aise.AiseUsuario;
import br.com.elotech.di.domain.aise.AiseUsuarioEntidadePK;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="aise.usuarioentidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class AiseUsuarioEntidade {
    @EmbeddedId
    @Valid
    private final AiseUsuarioEntidadePK pk = new AiseUsuarioEntidadePK();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean padrao;

    public Boolean getPadrao() {
        return this.padrao;
    }

    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    public AiseUsuarioEntidadePK getPk() {
        return this.pk;
    }

    public static AiseUsuarioEntidade of(AiseUsuario usuario, AiseEntidade entidade) {
        return new AiseUsuarioEntidade().withUsuario(usuario).withEntidade(entidade);
    }

    public AiseUsuarioEntidade withEntidade(AiseEntidade entidade) {
        this.pk.setEntidade(entidade);
        return this;
    }

    public AiseUsuarioEntidade withUsuario(AiseUsuario usuario) {
        this.pk.setUsuario(usuario);
        return this;
    }

    public AiseUsuarioEntidade withPadrao(Boolean padrao) {
        this.setPadrao(padrao);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseUsuarioEntidade)) {
            return false;
        }
        AiseUsuarioEntidade other = (AiseUsuarioEntidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AiseUsuarioEntidadePK this$pk = this.getPk();
        AiseUsuarioEntidadePK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseUsuarioEntidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AiseUsuarioEntidadePK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AiseUsuarioEntidade(pk=" + String.valueOf(this.getPk()) + ", padrao=" + this.getPadrao() + ")";
    }
}

