/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.aise.AiseNivelUsuario;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.aise.AiseUsuarioEntidade;
import br.com.elotech.di.domain.aise.AiseUsuarioModulo;
import br.com.elotech.di.replicate.support.Replicable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="aise.usuario")
@DynamicInsert
@DynamicUpdate
public class AiseUsuario
implements Replicable<Usuario, Long> {
    @Id
    @Column(name="usuario")
    @Length(max=250)
    private @Length(max=250) String id;
    @Column(length=60)
    @Length(max=60)
    private @Length(max=60) String senha;
    @ManyToOne
    private AiseNivelUsuario nivelUsuario;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    private AisePessoa pessoa;
    private Boolean ativo;
    @ManyToOne
    private AiseUsuario usuarioResponsavel;
    @Length(max=250)
    private @Length(max=250) String usuarioProtocolo;
    private Boolean novidades;
    private final Boolean salvaFiltroPesquisa = Boolean.FALSE;
    private Long idUnico;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.usuario")
    @Valid
    private final Set<AiseUsuarioEntidade> entidades = new HashSet();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.usuario")
    @Valid
    private final Set<AiseUsuarioModulo> modulos = new HashSet();

    public static AiseUsuario of(String id) {
        return new AiseUsuario().withId(id);
    }

    public AiseUsuario withId(String id) {
        this.setId(id);
        return this;
    }

    public AiseUsuario withSenha(String senha) {
        this.setSenha(senha);
        return this;
    }

    public AiseUsuario withAtivo(Boolean ativo) {
        this.setAtivo(ativo);
        return this;
    }

    @Generated
    public AiseUsuario() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSenha() {
        return this.senha;
    }

    @Generated
    public AiseNivelUsuario getNivelUsuario() {
        return this.nivelUsuario;
    }

    @Generated
    public AisePessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public AiseUsuario getUsuarioResponsavel() {
        return this.usuarioResponsavel;
    }

    @Generated
    public String getUsuarioProtocolo() {
        return this.usuarioProtocolo;
    }

    @Generated
    public Boolean getNovidades() {
        return this.novidades;
    }

    @Generated
    public Boolean getSalvaFiltroPesquisa() {
        return this.salvaFiltroPesquisa;
    }

    @Generated
    public Long getIdUnico() {
        return this.idUnico;
    }

    @Generated
    public Set<AiseUsuarioEntidade> getEntidades() {
        return this.entidades;
    }

    @Generated
    public Set<AiseUsuarioModulo> getModulos() {
        return this.modulos;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Generated
    public void setNivelUsuario(AiseNivelUsuario nivelUsuario) {
        this.nivelUsuario = nivelUsuario;
    }

    @Generated
    public void setPessoa(AisePessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setUsuarioResponsavel(AiseUsuario usuarioResponsavel) {
        this.usuarioResponsavel = usuarioResponsavel;
    }

    @Generated
    public void setUsuarioProtocolo(String usuarioProtocolo) {
        this.usuarioProtocolo = usuarioProtocolo;
    }

    @Generated
    public void setNovidades(Boolean novidades) {
        this.novidades = novidades;
    }

    @Generated
    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    @Generated
    public String toString() {
        return "AiseUsuario(id=" + this.getId() + ", pessoa=" + String.valueOf(this.getPessoa()) + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseUsuario)) {
            return false;
        }
        AiseUsuario other = (AiseUsuario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseUsuario;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

