/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.converter.TipoPessoaEnumConverter;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.aise.AiseBancoPessoa;
import br.com.elotech.di.domain.aise.AiseContatoPessoa;
import br.com.elotech.di.domain.aise.AiseDocumentoPessoa;
import br.com.elotech.di.domain.aise.AiseEnderecoPessoa;
import br.com.elotech.di.domain.aise.AisePessoaImagem;
import br.com.elotech.di.domain.aise.AisePessoaRH;
import br.com.elotech.di.domain.aise.AiseUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="aise.pessoa")
@DynamicInsert
@DynamicUpdate
public class AisePessoa
implements Serializable,
Replicable<Pessoa, Long> {
    private static final long serialVersionUID = 1L;
    @Id
    @EloSequence
    private Long pessoa;
    @Convert(converter=TipoPessoaEnumConverter.class)
    private TipoPessoa tipoPessoa;
    @Length(max=150)
    private @Length(max=150) String nome;
    @Length(max=150)
    private @Length(max=150) String nomeFantasia;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<AiseEnderecoPessoa> enderecos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<AiseBancoPessoa> bancos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<AiseContatoPessoa> contatos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<AiseDocumentoPessoa> documentos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<AisePessoaImagem> imagens = new ArrayList();
    @Column(name="CNPJ_CPF")
    @Length(max=20)
    private @Length(max=20) String cnpjCpf;
    @Length(max=20)
    private @Length(max=20) String rg;
    @Length(max=20)
    private @Length(max=20) String orgaoEmissor;
    private LocalDate dataEmissao;
    @Length(max=20)
    private @Length(max=20) String inscricaoEstadual;
    private Long sequenciaEndereco;
    private Long sequenciaContato;
    private Long sequenciaBanco;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean contribuinte;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean fornecedor;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean pessoal;
    private LocalDate dataInclusao;
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    @Length(max=250)
    private @Length(max=250) String usuarioInclusao;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="pais"), @JoinColumn(name="estadoEmissor")})
    private AiseUnidadeFederacao estadoEmissor;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean microEmpresa;
    private LocalDate dataAlteracao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean estrangeiro;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean autonomo;
    @Length(max=1000)
    private @Length(max=1000) String atividadePrincipal;
    @Column(name="inscricaoissqn")
    @Length(max=20)
    private @Length(max=20) String inscricaoMunicipal;
    private LocalDate dataIssqn;
    private Long fornecedorSiscop;
    @Length(max=18)
    private @Length(max=18) String codigoSistemaAnterior;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean inativo;
    private Long sequenciaImagem;
    @Length(max=60)
    private @Length(max=60) String activeFormOrigem;
    private LocalDate dataNascimento;
    @Length(max=12)
    private @Length(max=12) String nit;
    @Length(max=12)
    private @Length(max=12) String nire;
    @Column(name="pispasep")
    @Length(max=20)
    private @Length(max=20) String pis;
    private LocalDate dataAberturaCnpj;
    @Column(name="codigotce")
    @Length(max=20)
    private @Length(max=20) String idTcePR;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pessoa")
    private AisePessoaRH pessoaRH;
    private Long idUnico;
    @Length(max=150)
    private @Length(max=150) String nomeSocial;

    public static AisePessoa ofPessoa(Long pessoa) {
        AisePessoa aisePessoa = new AisePessoa();
        aisePessoa.setPessoa(pessoa);
        return aisePessoa;
    }

    public Long getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public Long getSequenciaContato() {
        return this.sequenciaContato;
    }

    public void setSequenciaContato(Long sequenciaContato) {
        this.sequenciaContato = sequenciaContato;
    }

    public Long getSequenciaBanco() {
        return this.sequenciaBanco;
    }

    public void setSequenciaBanco(Long sequenciaBanco) {
        this.sequenciaBanco = sequenciaBanco;
    }

    public Boolean getContribuinte() {
        return this.contribuinte;
    }

    public void setContribuinte(Boolean contribuinte) {
        this.contribuinte = contribuinte;
    }

    public Boolean getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Boolean fornecedor) {
        this.fornecedor = fornecedor;
    }

    public Boolean getPessoal() {
        return this.pessoal;
    }

    public void setPessoal(Boolean pessoal) {
        this.pessoal = pessoal;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(String usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public AiseUnidadeFederacao getEstadoEmissor() {
        return this.estadoEmissor;
    }

    public void setEstadoEmissor(AiseUnidadeFederacao estadoEmissor) {
        this.estadoEmissor = estadoEmissor;
    }

    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = microEmpresa;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public Boolean getEstrangeiro() {
        return this.estrangeiro;
    }

    public void setEstrangeiro(Boolean estrangeiro) {
        this.estrangeiro = estrangeiro;
    }

    public Boolean getAutonomo() {
        return this.autonomo;
    }

    public void setAutonomo(Boolean autonomo) {
        this.autonomo = autonomo;
    }

    public String getAtividadePrincipal() {
        return this.atividadePrincipal;
    }

    public void setAtividadePrincipal(String atividadePrincipal) {
        this.atividadePrincipal = atividadePrincipal;
    }

    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    public void setInscricaoMunicipal(String inscricaoMunicipal) {
        this.inscricaoMunicipal = inscricaoMunicipal;
    }

    public LocalDate getDataIssqn() {
        return this.dataIssqn;
    }

    public void setDataIssqn(LocalDate dataissqn) {
        this.dataIssqn = dataissqn;
    }

    public Long getFornecedorSiscop() {
        return this.fornecedorSiscop;
    }

    public void setFornecedorSiscop(Long fornecedorSiscop) {
        this.fornecedorSiscop = fornecedorSiscop;
    }

    public String getCodigoSistemaAnterior() {
        return this.codigoSistemaAnterior;
    }

    public void setCodigoSistemaAnterior(String codigoSistemaAnterior) {
        this.codigoSistemaAnterior = codigoSistemaAnterior;
    }

    public Boolean getInativo() {
        return BooleanUtils.toBoolean((Boolean)this.inativo);
    }

    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    public Long getSequenciaImagem() {
        return this.sequenciaImagem;
    }

    public void setSequenciaImagem(Long sequenciaImagem) {
        this.sequenciaImagem = sequenciaImagem;
    }

    public String getActiveFormOrigem() {
        return this.activeFormOrigem;
    }

    public void setActiveFormOrigem(String activeFormOrigem) {
        this.activeFormOrigem = activeFormOrigem;
    }

    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public String getNit() {
        return this.nit;
    }

    public void setNit(String nit) {
        this.nit = nit;
    }

    public String getNire() {
        return this.nire;
    }

    public void setNire(String nire) {
        this.nire = nire;
    }

    public String getPis() {
        return this.pis;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public LocalDate getDataAberturaCnpj() {
        return this.dataAberturaCnpj;
    }

    public void setDataAberturaCnpj(LocalDate dataAberturaCnpj) {
        this.dataAberturaCnpj = dataAberturaCnpj;
    }

    public String getIdTcePR() {
        return this.idTcePR;
    }

    public void setIdTcePR(String idTcePR) {
        this.idTcePR = idTcePR;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public List<AiseEnderecoPessoa> getEnderecos() {
        return this.enderecos;
    }

    public List<AiseBancoPessoa> getBancos() {
        return this.bancos;
    }

    public List<AiseContatoPessoa> getContatos() {
        return this.contatos;
    }

    public void setPessoaRH(AisePessoaRH pessoaRH) {
        this.pessoaRH = pessoaRH;
    }

    public AisePessoaRH getPessoaRH() {
        return this.pessoaRH;
    }

    public AiseEnderecoPessoa getEnderecoPrincipal() {
        for (AiseEnderecoPessoa aiseEnderecoPessoa : this.enderecos) {
            if (aiseEnderecoPessoa.getPk().getCodigo() == null || !aiseEnderecoPessoa.getPk().getCodigo().equals(this.sequenciaEndereco)) continue;
            return aiseEnderecoPessoa;
        }
        return null;
    }

    public void setEnderecoPrincipal(AiseEnderecoPessoa enderecoPrincipal) {
        this.sequenciaEndereco = null;
        if (enderecoPrincipal != null) {
            this.sequenciaEndereco = enderecoPrincipal.getPk().getCodigo();
        }
    }

    public AiseContatoPessoa getContatoPrincipal() {
        for (AiseContatoPessoa aiseContatoPessoa : this.contatos) {
            if (aiseContatoPessoa.getPk().getCodigo() == null || !aiseContatoPessoa.getPk().getCodigo().equals(this.sequenciaContato)) continue;
            return aiseContatoPessoa;
        }
        return null;
    }

    public void setContaBancariaPrincipal(AiseBancoPessoa contaBancariaPrincipal) {
        this.sequenciaBanco = null;
        if (contaBancariaPrincipal != null) {
            this.sequenciaBanco = contaBancariaPrincipal.getPk().getCodigo();
        }
    }

    public AiseBancoPessoa getContaBancariaPrincipal() {
        for (AiseBancoPessoa aiseContBancariaPessoa : this.bancos) {
            if (aiseContBancariaPessoa.getPk().getCodigo() == null || !aiseContBancariaPessoa.getPk().getCodigo().equals(this.sequenciaBanco)) continue;
            return aiseContBancariaPessoa;
        }
        return null;
    }

    public void setContatoPrincipal(AiseContatoPessoa contatoPrincipal) {
        this.sequenciaContato = null;
        if (contatoPrincipal != null) {
            this.sequenciaContato = contatoPrincipal.getPk().getCodigo();
        }
    }

    public static AisePessoa of(Long id) {
        return new AisePessoa().withId(id);
    }

    public AisePessoa withId(Long id) {
        this.setPessoa(id);
        return this;
    }

    public AisePessoa withContatoPrincipal(AiseContatoPessoa aiseContatoPessoa) {
        this.getContatos().add(aiseContatoPessoa);
        this.setSequenciaContato(aiseContatoPessoa.getPk().getCodigo());
        return this;
    }

    public List<AiseDocumentoPessoa> getDocumentos() {
        return this.documentos;
    }

    public List<AisePessoaImagem> getImagens() {
        return this.imagens;
    }

    public String getNomeSocial() {
        return this.nomeSocial;
    }

    public void setNomeSocial(String nomeSocial) {
        this.nomeSocial = nomeSocial;
    }

    @Generated
    public String toString() {
        return "AisePessoa(pessoa=" + this.getPessoa() + ", tipoPessoa=" + String.valueOf(this.getTipoPessoa()) + ", nome=" + this.getNome() + ", cnpjCpf=" + this.getCnpjCpf() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisePessoa)) {
            return false;
        }
        AisePessoa other = (AisePessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        return !(this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AisePessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        return result;
    }
}

