/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.ContribuicaoPrevidenciaria;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.FundoPrevidenciaSocial;
import br.com.elotech.di.domain.aise.AiseBairro;
import br.com.elotech.di.domain.aise.AiseCidade;
import br.com.elotech.di.domain.aise.AiseCnae;
import br.com.elotech.di.domain.aise.AiseLogradouro;
import br.com.elotech.di.replicate.support.Replicable;
import java.math.BigDecimal;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="aise.entidade")
public class AiseEntidade
implements EloEntity<Long>,
Replicable<Entidade, Long> {
    @Id
    @Column(name="entidade")
    @NotNull
    @Caption(value="Entidade")
    @EloSequence
    private Long id;
    @Caption(value="Nome")
    @Column(length=100)
    @Length(max=100)
    private @Length(max=100) String nome;
    @Column(length=60)
    @Length(max=60)
    private @Length(max=60) String complemento;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="cidade", referencedColumnName="cidade")), @JoinColumnOrFormula(column=@JoinColumn(name="logradouro", referencedColumnName="logradouro"))})
    private AiseLogradouro logradouro;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String numero;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="cidade", referencedColumnName="cidade")), @JoinColumnOrFormula(column=@JoinColumn(name="bairro", referencedColumnName="bairro"))})
    private AiseBairro bairro;
    @ManyToOne
    @JoinColumn
    private AiseCidade cidade;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String cep;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String cnpj;
    private Boolean entidadePrincipal;
    @Column(name="tipoEntidade")
    private EntidadeTipo tipo;
    @Caption(value="Entidade Console")
    @Column(name="entidadeconsole")
    @Type(type="uuid-char")
    private UUID entidadeConsole;
    private byte[] brasao;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String telefone;
    @Column(length=2)
    @Length(max=2)
    private @Length(max=2) String unidadeFederacao;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String identificacaoTCE;
    @Column(length=60)
    @Length(max=60)
    private @Length(max=60) String email;
    @Column(name="gps")
    private ContribuicaoPrevidenciaria contribuicaoPrevidenciaria;
    @Column(name="fpas")
    private FundoPrevidenciaSocial fundoPrevidenciaSocial;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    private AiseCnae cnae;
    private byte[] carimboCarneCorreios;
    private BigDecimal percentualIsencaoFilantropica;
    private Long idUnico;

    public static AiseEntidade of(Long id) {
        AiseEntidade entidade = new AiseEntidade();
        entidade.setId(id);
        return entidade;
    }

    public AiseEntidade withNome(String nome) {
        this.nome = nome;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public Boolean getEntidadePrincipal() {
        return this.entidadePrincipal;
    }

    public void setEntidadePrincipal(Boolean entidadePrincipal) {
        this.entidadePrincipal = entidadePrincipal;
    }

    public EntidadeTipo getTipo() {
        return this.tipo;
    }

    public void setTipo(EntidadeTipo tipo) {
        this.tipo = tipo;
    }

    public AiseCidade getCidade() {
        return this.cidade;
    }

    public void setCidade(AiseCidade cidade) {
        this.cidade = cidade;
    }

    public AiseLogradouro getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(AiseLogradouro logradouro) {
        this.logradouro = logradouro;
    }

    public AiseBairro getBairro() {
        return this.bairro;
    }

    public void setBairro(AiseBairro bairro) {
        this.bairro = bairro;
    }

    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public byte[] getBrasao() {
        return this.brasao;
    }

    public void setBrasao(byte[] brasao) {
        this.brasao = brasao;
    }

    public byte[] getCarimboCarneCorreios() {
        return this.carimboCarneCorreios;
    }

    public void setCarimboCarneCorreios(byte[] carimboCarneCorreios) {
        this.carimboCarneCorreios = carimboCarneCorreios;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getIdentificacaoTCE() {
        return this.identificacaoTCE;
    }

    public void setIdentificacaoTCE(String identificacaoTCE) {
        this.identificacaoTCE = identificacaoTCE;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public BigDecimal getPercentualIsencaoFilantropica() {
        return this.percentualIsencaoFilantropica;
    }

    public void setPercentualIsencaoFilantropica(BigDecimal percentualIsencaoFilantropica) {
        this.percentualIsencaoFilantropica = percentualIsencaoFilantropica;
    }

    public void setContribuicaoPrevidenciaria(ContribuicaoPrevidenciaria contribuicaoPrevidenciaria) {
        this.contribuicaoPrevidenciaria = contribuicaoPrevidenciaria;
    }

    public ContribuicaoPrevidenciaria getContribuicaoPrevidenciaria() {
        return this.contribuicaoPrevidenciaria;
    }

    public FundoPrevidenciaSocial getFundoPrevidenciaSocial() {
        return this.fundoPrevidenciaSocial;
    }

    public void setFundoPrevidenciaSocial(FundoPrevidenciaSocial fundoPrevidenciaSocial) {
        this.fundoPrevidenciaSocial = fundoPrevidenciaSocial;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setCnae(AiseCnae cnae) {
        this.cnae = cnae;
    }

    public AiseCnae getCnae() {
        return this.cnae;
    }

    public AiseEntidade withIdUnico(Long idUnico) {
        this.setIdUnico(idUnico);
        return this;
    }

    public UUID getEntidadeConsole() {
        return this.entidadeConsole;
    }

    public void setEntidadeConsole(UUID entidadeConsole) {
        this.entidadeConsole = entidadeConsole;
    }

    @Generated
    public String toString() {
        return "AiseEntidade(id=" + this.getId() + ", nome=" + this.getNome() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseEntidade)) {
            return false;
        }
        AiseEntidade other = (AiseEntidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseEntidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

