/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.core.converter.EnderecoTipoStringConverter;
import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.di.domain.aise.AiseBairro;
import br.com.elotech.di.domain.aise.AiseCidade;
import br.com.elotech.di.domain.aise.AiseEnderecoPessoaPK;
import br.com.elotech.di.domain.aise.AiseLogradouro;
import br.com.elotech.di.domain.aise.AiseUnidadeFederacao;
import java.time.LocalDate;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="aise.enderecopessoa")
@DynamicInsert
@DynamicUpdate
public class AiseEnderecoPessoa {
    @EmbeddedId
    @Valid
    private final AiseEnderecoPessoaPK pk = new AiseEnderecoPessoaPK();
    @Convert(converter=EnderecoTipoStringConverter.class)
    private EnderecoTipo tipoEndereco;
    @Length(max=1)
    private @Length(max=1) String domicilioFiscalEstabelecido;
    @Length(max=10)
    private @Length(max=10) String numero;
    @Length(max=100)
    private @Length(max=100) String complemento;
    @ManyToOne
    @JoinColumn
    private AiseCidade cidade;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="cidade", referencedColumnName="cidade")), @JoinColumnOrFormula(column=@JoinColumn(name="logradouro", referencedColumnName="logradouro"))})
    private AiseLogradouro logradouro;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="cidade", referencedColumnName="cidade")), @JoinColumnOrFormula(column=@JoinColumn(name="bairro", referencedColumnName="bairro"))})
    private AiseBairro bairro;
    private Long cep;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="pais"), @JoinColumn(name="unidadeFederacao")})
    private AiseUnidadeFederacao unidadeFederacao;
    private LocalDate dataAlteracao;
    private Long idUnico;

    public AiseEnderecoPessoaPK getPk() {
        return this.pk;
    }

    public EnderecoTipo getTipoEndereco() {
        return this.tipoEndereco;
    }

    public void setTipoEndereco(EnderecoTipo tipoEndereco) {
        this.tipoEndereco = tipoEndereco;
    }

    public String getDomicilioFiscalEstabelecido() {
        return this.domicilioFiscalEstabelecido;
    }

    public void setDomicilioFiscalEstabelecido(String domicilioFiscalEstabelecido) {
        this.domicilioFiscalEstabelecido = domicilioFiscalEstabelecido;
    }

    public AiseLogradouro getLogradouro() {
        return this.logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public AiseCidade getCidade() {
        return this.cidade;
    }

    public void setCidade(AiseCidade cidade) {
        this.cidade = cidade;
    }

    public AiseBairro getBairro() {
        return this.bairro;
    }

    public void setLogradouro(AiseLogradouro logradouro) {
        this.logradouro = logradouro;
    }

    public void setBairro(AiseBairro bairro) {
        this.bairro = bairro;
    }

    public Long getCep() {
        return this.cep;
    }

    public void setCep(Long cep) {
        this.cep = cep;
    }

    public AiseUnidadeFederacao getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    public void setUnidadeFederacao(AiseUnidadeFederacao unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    @Generated
    public String toString() {
        return "AiseEnderecoPessoa(pk=" + String.valueOf(this.getPk()) + ", tipoEndereco=" + String.valueOf(this.getTipoEndereco()) + ", domicilioFiscalEstabelecido=" + this.getDomicilioFiscalEstabelecido() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cidade=" + String.valueOf(this.getCidade()) + ", logradouro=" + String.valueOf(this.getLogradouro()) + ", bairro=" + String.valueOf(this.getBairro()) + ", cep=" + this.getCep() + ", unidadeFederacao=" + String.valueOf(this.getUnidadeFederacao()) + ", dataAlteracao=" + String.valueOf(this.getDataAlteracao()) + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseEnderecoPessoa)) {
            return false;
        }
        AiseEnderecoPessoa other = (AiseEnderecoPessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AiseEnderecoPessoaPK this$pk = this.getPk();
        AiseEnderecoPessoaPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseEnderecoPessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AiseEnderecoPessoaPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }
}

