/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.aise.AiseContatoPessoaPK;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="aise.contatopessoa")
@DynamicInsert
@DynamicUpdate
public class AiseContatoPessoa {
    @EmbeddedId
    @Valid
    private AiseContatoPessoaPK pk = new AiseContatoPessoaPK();
    @Length(max=60)
    private @Length(max=60) String nome;
    @Length(max=20)
    private @Length(max=20) String telefoneresidencial;
    @Length(max=20)
    private @Length(max=20) String telefonecomercial;
    @Length(max=20)
    private @Length(max=20) String telefonefax;
    @Length(max=20)
    private @Length(max=20) String telefonecelular;
    @Length(max=100)
    private @Length(max=100) String email;
    @Length(max=100)
    private @Length(max=100) String homepage;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean representanteLegal = Boolean.FALSE;
    private Long idUnico;

    public AiseContatoPessoa withPk(AiseContatoPessoaPK pk) {
        this.pk = pk;
        return this;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getTelefoneresidencial() {
        return this.telefoneresidencial;
    }

    public void setTelefoneresidencial(String telefoneresidencial) {
        this.telefoneresidencial = telefoneresidencial;
    }

    public String getTelefonecomercial() {
        return this.telefonecomercial;
    }

    public void setTelefonecomercial(String telefonecomercial) {
        this.telefonecomercial = telefonecomercial;
    }

    public String getTelefonefax() {
        return this.telefonefax;
    }

    public void setTelefonefax(String telefonefax) {
        this.telefonefax = telefonefax;
    }

    public String getTelefonecelular() {
        return this.telefonecelular;
    }

    public void setTelefonecelular(String telefonecelular) {
        this.telefonecelular = telefonecelular;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setRepresentanteLegal(Boolean representanteLegal) {
        this.representanteLegal = representanteLegal;
    }

    public Boolean getRepresentanteLegal() {
        return this.representanteLegal;
    }

    public AiseContatoPessoaPK getPk() {
        return this.pk;
    }

    public AiseContatoPessoa setPk(AiseContatoPessoaPK pk) {
        this.pk = pk;
        return this;
    }

    public static AiseContatoPessoa of(Long id) {
        return new AiseContatoPessoa().withId(id);
    }

    private AiseContatoPessoa withId(Long id) {
        this.getPk().setCodigo(id);
        return this;
    }

    public AiseContatoPessoa withEmail(String email) {
        this.setEmail(email);
        return this;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    @Generated
    public String toString() {
        return "AiseContatoPessoa(pk=" + String.valueOf(this.getPk()) + ", nome=" + this.getNome() + ", telefoneresidencial=" + this.getTelefoneresidencial() + ", telefonecomercial=" + this.getTelefonecomercial() + ", telefonefax=" + this.getTelefonefax() + ", telefonecelular=" + this.getTelefonecelular() + ", email=" + this.getEmail() + ", homepage=" + this.getHomepage() + ", representanteLegal=" + this.getRepresentanteLegal() + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseContatoPessoa)) {
            return false;
        }
        AiseContatoPessoa other = (AiseContatoPessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AiseContatoPessoaPK this$pk = this.getPk();
        AiseContatoPessoaPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseContatoPessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AiseContatoPessoaPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }
}

