/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.aise.AiseUnidadeFederacao;
import br.com.elotech.di.replicate.support.Replicable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="aise.cidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class AiseCidade
implements Replicable<Cidade, Long> {
    @Id
    @EloSequence
    @Column(name="cidade")
    private Long codigo;
    @Length(max=100)
    private @Length(max=100) String descricao;
    @Length(max=100)
    private @Length(max=100) String descricaoAbreviada;
    @Length(max=20)
    private @Length(max=20) String codigoNacional;
    private Long codigoIbge;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativa = Boolean.TRUE;
    private Long idUnico;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="pais"), @JoinColumn(name="unidadefederacao")})
    private AiseUnidadeFederacao uf;

    public AiseCidade() {
    }

    public AiseCidade(Long codigo) {
        this.codigo = codigo;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getDescricaoAbreviada() {
        return this.descricaoAbreviada;
    }

    public void setDescricaoAbreviada(String descricaoAbreviada) {
        this.descricaoAbreviada = descricaoAbreviada;
    }

    public String getCodigoNacional() {
        return this.codigoNacional;
    }

    public void setCodigoNacional(String codigoNacional) {
        this.codigoNacional = codigoNacional;
    }

    public Long getCodigoIbge() {
        return this.codigoIbge;
    }

    public void setCodigoIbge(Long codigoIbge) {
        this.codigoIbge = codigoIbge;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public AiseUnidadeFederacao getUf() {
        return this.uf;
    }

    public void setUf(AiseUnidadeFederacao uf) {
        this.uf = uf;
    }

    public Boolean getAtiva() {
        return this.ativa;
    }

    public void setAtiva(Boolean ativa) {
        this.ativa = ativa;
    }

    public AiseCidade withCodigo(Long codigo) {
        this.codigo = codigo;
        return this;
    }

    @Generated
    public String toString() {
        return "AiseCidade(codigo=" + this.getCodigo() + ", descricao=" + this.getDescricao() + ", descricaoAbreviada=" + this.getDescricaoAbreviada() + ", codigoNacional=" + this.getCodigoNacional() + ", codigoIbge=" + this.getCodigoIbge() + ", ativa=" + this.getAtiva() + ", idUnico=" + this.getIdUnico() + ", uf=" + String.valueOf(this.getUf()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseCidade)) {
            return false;
        }
        AiseCidade other = (AiseCidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseCidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

