/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.aise;

import br.com.elotech.di.domain.AtoEsferaGoverno;
import br.com.elotech.di.domain.AtoSituacao;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.aise.AiseAtoPK;
import br.com.elotech.di.domain.aise.AiseAtoPublicacao;
import br.com.elotech.di.domain.aise.AiseEntidade;
import br.com.elotech.di.domain.aise.AiseModulo;
import br.com.elotech.di.domain.aise.AiseTipoAto;
import br.com.elotech.di.domain.aise.AiseTipoDocumentoLegal;
import br.com.elotech.di.domain.aise.AiseTipoEscopoLei;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.replicate.support.Replicable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="aise.cgato")
@DynamicInsert
@DynamicUpdate
public class AiseAto
implements Replicable<LeiAto, Long> {
    public static final Long NUMERO_INVALIDO = 9999L;
    public static final Long TIPO_DOCUMENTO_LEGAL_INVALIDO = 999L;
    @EmbeddedId
    @Valid
    private final AiseAtoPK id = new AiseAtoPK();
    @Column(insertable=false, updatable=false)
    private Long idUnicoAtoISS;
    @ManyToOne
    @JoinColumn(name="idtipodocumentolegal", referencedColumnName="id")
    private AiseTipoDocumentoLegal tipoDocumentoLegal;
    @ManyToOne
    @JoinColumn(name="idtipoescopolei", referencedColumnName="id")
    private AiseTipoEscopoLei tipoEscopoLei;
    @ManyToOne
    @JoinColumn
    private AiseTipoAto tipoAto;
    private Long numeroAto;
    private Long anoAto;
    @Column(name="ESFERA", length=1)
    private AtoEsferaGoverno esfera;
    private LocalDate dataAto;
    private LocalDate dataPublicacao;
    private LocalDate dataInicioVigencia;
    private LocalDate dataFimVigencia;
    @Column(length=1)
    private AtoSituacao situacao;
    @Length(max=4000)
    private @Length(max=4000) String descricao;
    @Length(max=20)
    private @Length(max=20) String numeroAtoTce;
    private Long numeroEdicao;
    private Long anoEdicao;
    private LocalDate dataGeracaoTc;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidadeleiautor", referencedColumnName="entidade"), @JoinColumn(name="leiautorizativa", referencedColumnName="idato")})
    private AiseAto leiAutorizativa;
    private LocalDate dataCadastro;
    private Long idTce;
    @ManyToOne
    private AiseModulo modulo;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="id.ato")
    private final List<AiseAtoPublicacao> publicacoes = new ArrayList();
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="idarquivo")
    private Arquivo arquivo;
    private Long idUnico;

    public AiseAtoPK getId() {
        return this.id;
    }

    public Long getIdUnicoAtoISS() {
        return this.idUnicoAtoISS;
    }

    public AiseTipoDocumentoLegal getTipoDocumentoLegal() {
        return this.tipoDocumentoLegal;
    }

    public void setTipoDocumentoLegal(AiseTipoDocumentoLegal tipoDocumentoLegal) {
        this.tipoDocumentoLegal = tipoDocumentoLegal;
    }

    public AiseTipoEscopoLei getTipoEscopoLei() {
        return this.tipoEscopoLei;
    }

    public void setTipoEscopoLei(AiseTipoEscopoLei tipoEscopoLei) {
        this.tipoEscopoLei = tipoEscopoLei;
    }

    public AiseTipoAto getTipoAto() {
        return this.tipoAto;
    }

    public void setTipoAto(AiseTipoAto tipoAto) {
        this.tipoAto = tipoAto;
    }

    public Long getNumeroAto() {
        return this.numeroAto;
    }

    public void setNumeroAto(Long numeroAto) {
        this.numeroAto = numeroAto;
    }

    public Long getAnoAto() {
        return this.anoAto;
    }

    public void setAnoAto(Long anoAto) {
        this.anoAto = anoAto;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getNumeroAtoTce() {
        return this.numeroAtoTce;
    }

    public void setNumeroAtoTce(String numeroAtoTce) {
        this.numeroAtoTce = numeroAtoTce;
    }

    public Long getNumeroEdicao() {
        return this.numeroEdicao;
    }

    public void setNumeroEdicao(Long numeroEdicao) {
        this.numeroEdicao = numeroEdicao;
    }

    public Long getAnoEdicao() {
        return this.anoEdicao;
    }

    public void setAnoEdicao(Long anoEdicao) {
        this.anoEdicao = anoEdicao;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public Long getTipoDocumentoLegalCodigo() {
        if (this.tipoDocumentoLegal == null) {
            return TIPO_DOCUMENTO_LEGAL_INVALIDO;
        }
        return this.tipoDocumentoLegal.getCodigo();
    }

    public Long getTipoEscopoLeiCodigo() {
        if (this.tipoEscopoLei == null) {
            return null;
        }
        return this.tipoEscopoLei.getCodigo();
    }

    public Long getTipoAtoCodigo() {
        if (this.tipoAto == null) {
            return null;
        }
        return Long.getLong(this.tipoAto.getCodigo());
    }

    public AiseAto withNumero(Long numero) {
        this.setNumeroAto(numero);
        return this;
    }

    public AiseAto withIdAto(Long id) {
        this.getId().setIdAto(id);
        return this;
    }

    public AtoEsferaGoverno getEsfera() {
        return this.esfera;
    }

    public void setEsfera(AtoEsferaGoverno esfera) {
        this.esfera = esfera;
    }

    public AtoSituacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(AtoSituacao situacao) {
        this.situacao = situacao;
    }

    public LocalDate getDataAto() {
        return this.dataAto;
    }

    public void setDataAto(LocalDate dataAto) {
        this.dataAto = dataAto;
    }

    public LocalDate getDataPublicacao() {
        return this.dataPublicacao;
    }

    public void setDataPublicacao(LocalDate dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    public LocalDate getDataInicioVigencia() {
        return this.dataInicioVigencia;
    }

    public void setDataInicioVigencia(LocalDate dataInicioVigencia) {
        this.dataInicioVigencia = dataInicioVigencia;
    }

    public LocalDate getDataFimVigencia() {
        return this.dataFimVigencia;
    }

    public void setDataFimVigencia(LocalDate dataFimVigencia) {
        this.dataFimVigencia = dataFimVigencia;
    }

    public AiseAto getLeiAutorizativa() {
        return this.leiAutorizativa;
    }

    public void setLeiAutorizativa(AiseAto leiAutorizativa) {
        this.leiAutorizativa = leiAutorizativa;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public Long getIdTce() {
        return this.idTce;
    }

    public void setIdTce(Long idTce) {
        this.idTce = idTce;
    }

    public AiseModulo getModulo() {
        return this.modulo;
    }

    public void setModulo(AiseModulo modulo) {
        this.modulo = modulo;
    }

    public LocalDate getDataGeracaoTc() {
        return this.dataGeracaoTc;
    }

    public void setDataGeracaoTc(LocalDate dataGeracaoTc) {
        this.dataGeracaoTc = dataGeracaoTc;
    }

    public List<AiseAtoPublicacao> getPublicacoes() {
        return this.publicacoes;
    }

    public Arquivo getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(Arquivo arquivo) {
        this.arquivo = arquivo;
    }

    public static AiseAto of(AiseEntidade entidade, Long id) {
        AiseAto ato = new AiseAto();
        ato.id.setEntidade(entidade);
        ato.id.setIdAto(id);
        return ato;
    }

    public AiseAto withLeiAutorizativa(AiseAto aiseAto) {
        this.setLeiAutorizativa(aiseAto);
        return this;
    }

    @Generated
    public String toString() {
        return "AiseAto(id=" + String.valueOf(this.getId()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseAto)) {
            return false;
        }
        AiseAto other = (AiseAto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AiseAtoPK this$id = this.getId();
        AiseAtoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseAto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AiseAtoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

