/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.ToModel;
import br.com.elotech.core.validation.ConditionalValid;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.TipoLicitacao;
import br.com.elotech.di.domain.TipoVeiculoPublicacao;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.domain.support.EloDomain;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Table(name="unico.veiculopublicacao")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
@ConditionalValid(condition="possuiLicitacao && !(T(br.com.elotech.di.batch.job.BatchContextHolder).isRunning())", activateGroups={ValidaLicitacao.class})
@JsonFilterFields(of={"id", "codigoOperacao", "codigoAtosPessoal", "possuiLicitacao", "anoLicitacao", "numeroLicitacao", "entidadeLicitacao.id", "entidadeLicitacao.nome", "entidadeLicitacao.identificacaoTCE", "tipoLicitacao.id", "tipoLicitacao.codigo", "tipoLicitacao.descricao", "dataAlteracao", "dataCadastro", "descricao", "dataEnvio", "motivoBaixa", "observacao", "dataBaixa", "pessoa.id", "pessoa.nome", "pessoa.cnpjCpf", "pessoa.tipoPessoa", "entidade.id", "entidade.nome", "tipoVeiculoPublicacao.id", "tipoVeiculoPublicacao.codigo", "tipoVeiculoPublicacao.descricao", "leiAto.id", "leiAto.idTce", "leiAto.numero", "leiAto.ano", "leiAto.sumula", "leiAto.tipoLeiNatureza.id", "leiAto.tipoLeiNatureza.codigo", "leiAto.tipoLeiNatureza.descricao"})
public class VeiculoPublicacao
extends EloDomain<Long> {
    public static final Long COD_OPERACAO_INVALIDA = 9999L;
    @Id
    @EloSequence
    private Long id;
    @NotNull
    @Caption(value="C\u00f3digo")
    private Long codigoOperacao;
    @Column(length=50)
    private String codigoAtosPessoal;
    @Caption(value="Possu\u00ed Licita\u00e7\u00e3o")
    private Boolean possuiLicitacao = Boolean.FALSE;
    @NotNull(groups={ValidaLicitacao.class})
    @Caption(value="Ano Licita\u00e7\u00e3o")
    private Long anoLicitacao;
    @NotNull(groups={ValidaLicitacao.class})
    @Caption(value="N\u00famero Licita\u00e7\u00e3o")
    private Long numeroLicitacao;
    @ManyToOne
    @ToModel(of={"id", "nome", "identificacaoTCE"})
    @NotNull(groups={ValidaLicitacao.class})
    @Caption(value="Entidade Licita\u00e7\u00e3o")
    private Entidade entidadeLicitacao;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @NotNull(groups={ValidaLicitacao.class})
    @Caption(value="Tipo Licita\u00e7\u00e3o")
    private TipoLicitacao tipoLicitacao;
    private LocalDate dataAlteracao;
    @Caption(value="Data In\u00edcio")
    private LocalDate dataCadastro;
    @Column(length=60)
    @Caption(value="Descri\u00e7\u00e3o")
    private String descricao;
    @Caption(value="Data Envio")
    private LocalDate dataEnvio;
    @Column(length=250)
    private String motivoBaixa;
    @Column(length=250)
    private String observacao;
    @Caption(value="Data Baixa")
    private LocalDate dataBaixa;
    @ManyToOne
    @ToModel(of={"id", "nome", "tipoPessoa", "cnpjCpf"})
    private Pessoa pessoa;
    @ManyToOne
    @ToModel(of={"id", "nome"})
    @NotNull
    private Entidade entidade;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private TipoVeiculoPublicacao tipoVeiculoPublicacao;
    @ManyToOne
    @ToModel(of={"id", "idTce", "numero", "ano", "tipoLeiDocumento", "tipoLeiEscopo.id", "tipoLeiEscopo.codigo", "tipoLeiEscopo.descricao", "tipoLeiNatureza.id", "tipoLeiNatureza.codigo", "tipoLeiNatureza.descricao"})
    private LeiAto leiAto;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCodigoAtosPessoal() {
        return this.codigoAtosPessoal;
    }

    public void setCodigoAtosPessoal(String codigoAtosPessoal) {
        this.codigoAtosPessoal = codigoAtosPessoal;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Long getCodigoOperacao() {
        return this.codigoOperacao;
    }

    public void setCodigoOperacao(Long codigoOperacao) {
        this.codigoOperacao = codigoOperacao;
    }

    public LocalDate getDataEnvio() {
        return this.dataEnvio;
    }

    public void setDataEnvio(LocalDate dataEnvio) {
        this.dataEnvio = dataEnvio;
    }

    public String getMotivoBaixa() {
        return this.motivoBaixa;
    }

    public void setMotivoBaixa(String motivoBaixa) {
        this.motivoBaixa = motivoBaixa;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public LocalDate getDataBaixa() {
        return this.dataBaixa;
    }

    public void setDataBaixa(LocalDate dataBaixa) {
        this.dataBaixa = dataBaixa;
    }

    public Entidade getEntidadeLicitacao() {
        return this.entidadeLicitacao;
    }

    public void setEntidadeLicitacao(Entidade entidadeLicitacao) {
        this.entidadeLicitacao = entidadeLicitacao;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public TipoLicitacao getTipoLicitacao() {
        return this.tipoLicitacao;
    }

    public void setTipoLicitacao(TipoLicitacao tipoLicitacao) {
        this.tipoLicitacao = tipoLicitacao;
    }

    public TipoVeiculoPublicacao getTipoVeiculoPublicacao() {
        return this.tipoVeiculoPublicacao;
    }

    public void setTipoVeiculoPublicacao(TipoVeiculoPublicacao tipoVeiculoPublicacao) {
        this.tipoVeiculoPublicacao = tipoVeiculoPublicacao;
    }

    public LeiAto getLeiAto() {
        return this.leiAto;
    }

    public void setLeiAto(LeiAto leiAto) {
        this.leiAto = leiAto;
    }

    public Long getAnoLicitacao() {
        return this.anoLicitacao;
    }

    public void setAnoLicitacao(Long anoLicitacao) {
        this.anoLicitacao = anoLicitacao;
    }

    public Long getNumeroLicitacao() {
        return this.numeroLicitacao;
    }

    public void setNumeroLicitacao(Long numeroLicitacao) {
        this.numeroLicitacao = numeroLicitacao;
    }

    public Boolean getPossuiLicitacao() {
        return this.possuiLicitacao;
    }

    public void setPossuiLicitacao(Boolean possuiLicitacao) {
        this.possuiLicitacao = BooleanUtils.toBoolean((Boolean)possuiLicitacao);
    }

    public VeiculoPublicacao withId(Long id) {
        this.setId(id);
        return this;
    }

    public static VeiculoPublicacao of(Long id) {
        return new VeiculoPublicacao().withId(id);
    }

    public VeiculoPublicacao withLeiAto(LeiAto leiAto) {
        this.setLeiAto(leiAto);
        return this;
    }

    public boolean isBaixado() {
        return Objects.nonNull(this.dataBaixa) || !StringUtils.isEmpty((CharSequence)this.motivoBaixa);
    }

    @Generated
    public String toString() {
        return "VeiculoPublicacao(id=" + this.getId() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VeiculoPublicacao)) {
            return false;
        }
        VeiculoPublicacao other = (VeiculoPublicacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VeiculoPublicacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

