/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.caelum.stella.bean.validation.CPF;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.core.metamodel.annotation.ToModel;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.Grupo;
import br.com.elotech.di.domain.Recurso;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioHorarioAcesso;
import br.com.elotech.di.domain.UsuarioModoAutenticacao;
import br.com.elotech.di.domain.UsuarioModulo;
import br.com.elotech.di.domain.aise.AiseUsuario;
import br.com.elotech.di.domain.apice.ApiceUsuario;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuario;
import br.com.elotech.di.domain.siscop.SiscopUsuario;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.validation.SkipBatch;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.usuario")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
@JsonFilterFields(of={"id", "usuario", "email", "nome", "cargo", "cpf", "ativo", "contaBloqueada", "senhaExpirada", "modoAutenticacao", "rg.numero", "rg.dataEmissao", "rg.orgaoEmissor", "rg.uf.id", "rg.uf.sigla", "usuarioResponsavel.id", "usuarioResponsavel.usuario", "usuarioResponsavel.nome", "rg.uf.descricao", "dataExpiracao", "matricula", "modulos.id", "modulos.modulo.id", "modulos.modulo.descricao", "modulos.principal", "grupos.nome", "grupos.id", "invalido", "usuarioRecursos.nome", "entidades.id", "entidades.entidade.nome", "entidades.entidade.id", "entidades.principal", "usuarioOriginal", "qtdDiasSenhaExpira", "horariosAcesso.id", "horariosAcesso.usuario", "horariosAcesso.diaSemana", "horariosAcesso.entrada1", "horariosAcesso.saida1", "horariosAcesso.entrada2", "horariosAcesso.saida2", "motivoContaBloqueada", "failedLoginAttempts"})
public class Usuario
extends EloDomain<Long> {
    public static final int TAMANHO_SENHA_LEGADO = 14;
    public static final int MAX_USER_NAME_LENGHT = 250;
    public static final Map<List<ModuloEnum>, Class<?>> USUARIO_MODULE_CLASS = new HashMap();
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotBlank
    @Column(name="usuario", length=250)
    @Caption(value="Usu\u00e1rio")
    private String usuario;
    @Column(length=60)
    @Caption(value="Senha")
    @NotAudited
    private String senha;
    @Caption(value="Ativo")
    private Boolean ativo = Boolean.TRUE;
    @Email(groups={SkipBatch.class})
    @Column(length=100)
    @Caption(value="Email")
    @NotNull(groups={SkipBatch.class})
    private String email;
    @NotBlank(groups={SkipBatch.class})
    @Length(min=3, max=150, groups={SkipBatch.class})
    @Caption(value="Nome")
    @Column(length=150)
    private @NotBlank(groups={SkipBatch.class}) @Length(min=3, max=150, groups={SkipBatch.class}) String nome;
    @Length(max=20)
    @Caption(value="CPF")
    @CPF(groups={SkipBatch.class})
    private @Length(max=20) String cpf;
    @Length(max=60)
    @Caption(value="Cargo")
    private @Length(max=60) String cargo;
    @Length(max=30)
    @Caption(value="Matr\u00edcula")
    private @Length(max=30) String matricula;
    @Caption(value="Data Expira\u00e7\u00e3o")
    private LocalDate dataExpiracao;
    @ManyToOne
    @ToModel(of={"id", "usuario", "nome"})
    @Caption(value="Respons\u00e1vel")
    private Usuario usuarioResponsavel;
    @Embedded
    @Caption(value="RG")
    @Valid
    private Rg rg;
    @Type(type="uuid-char")
    private UUID idKeycloak;
    @Valid
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="usuario", updatable=false, nullable=false)
    @Caption(value="Entidades")
    @AuditJoinTable(name="unico.usuario_usuarioentidade_aud")
    private final List<UsuarioEntidade> entidades = new ArrayList();
    @Valid
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="usuario", updatable=false, nullable=false)
    @Caption(value="M\u00f3dulos")
    @AuditJoinTable(name="unico.usuario_usuariomodulo_aud")
    private final List<UsuarioModulo> modulos = new ArrayList();
    @OneToMany
    @JoinTable(name="unico.usuariogrupo", joinColumns={@JoinColumn(name="usuario", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="grupo", referencedColumnName="id")})
    @Caption(value="Grupos")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private final Set<Grupo> grupos = new HashSet();
    @OneToMany
    @JoinTable(name="unico.usuariorecurso", joinColumns={@JoinColumn(name="usuario", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="recurso", referencedColumnName="id")})
    @Caption(value="Recursos")
    @JsonIgnore
    @MetaModelIgnore
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private final Set<Recurso> usuarioRecursos = new HashSet();
    @Caption(value="Conta Bloqueada")
    private Boolean contaBloqueada = Boolean.FALSE;
    @Caption(value="Senha Expirada")
    private Boolean senhaExpirada = Boolean.FALSE;
    @Column(length=1)
    @Caption(value="Modo Autentica\u00e7\u00e3o")
    private UsuarioModoAutenticacao modoAutenticacao = UsuarioModoAutenticacao.INTERNO;
    @Column(length=250)
    @Caption(value="Usu\u00e1rio Original")
    private String usuarioOriginal;
    @Caption(value="Inv\u00e1lido")
    private Boolean invalido = Boolean.FALSE;
    @Caption(value="Senha expira a cada x Dias")
    private Long qtdDiasSenhaExpira;
    @Caption(value="Tentativas falhas de login")
    private Long failedLoginAttempts;
    @Valid
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="usuario", updatable=false, nullable=false)
    @Caption(value="Hor\u00e1rios de Acesso")
    @AuditJoinTable(name="unico.usuario_usuariohorarioaces_aud")
    private final List<UsuarioHorarioAcesso> horariosAcesso = new ArrayList();
    @Caption(value="Motivo conta bloqueada")
    @Column(length=250)
    private String motivoContaBloqueada;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    @JsonIgnore
    public String getSenha() {
        return this.senha;
    }

    @JsonProperty
    public void setSenha(String senha) {
        this.senha = senha;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public LocalDate getDataExpiracao() {
        return this.dataExpiracao;
    }

    public void setDataExpiracao(LocalDate dataExpiracao) {
        this.dataExpiracao = dataExpiracao;
    }

    public Usuario getUsuarioResponsavel() {
        return this.usuarioResponsavel;
    }

    public List<UsuarioEntidade> getEntidades() {
        return this.entidades;
    }

    public List<UsuarioModulo> getModulos() {
        return Optional.of(this.modulos).orElse(new ArrayList());
    }

    public void setUsuarioResponsavel(Usuario usuarioResponsavel) {
        this.usuarioResponsavel = usuarioResponsavel;
    }

    public Usuario withId(Long id) {
        this.setId(id);
        return this;
    }

    public static Usuario of(Long id) {
        return new Usuario().withId(id);
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
        if (!Objects.isNull(this.usuario) && this.isNew()) {
            this.usuario = this.usuario.toLowerCase(Locale.getDefault());
        }
    }

    public Usuario withUsuario(String usuario) {
        this.setUsuario(usuario);
        return this;
    }

    public Boolean getSenhaExpirada() {
        return this.senhaExpirada;
    }

    public Boolean getContaBloqueada() {
        return this.contaBloqueada;
    }

    public void setContaBloqueada(Boolean contaBloqueada) {
        this.contaBloqueada = contaBloqueada;
    }

    public void setSenhaExpirada(Boolean senhaExpirada) {
        this.senhaExpirada = senhaExpirada;
    }

    public void setFailedLoginAttempts(Long failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
    }

    public Long getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public String hashString() {
        if (this.isFixedUser()) {
            return ReplicatorFacade.hashCodeStringCaseSensitive((String)this.usuario);
        }
        return ReplicatorFacade.hashCodeStringCaseSensitive((String)this.usuario) + ReplicatorFacade.hashCodeString((String)StringUtils.defaultIfBlank((String)this.cpf, (String)UUID.randomUUID().toString()));
    }

    @JsonIgnore
    public boolean isFixedUser() {
        return "master".equalsIgnoreCase(this.usuario) || "tecnico".equalsIgnoreCase(this.usuario) || "root".equalsIgnoreCase(this.usuario) || "representante".equalsIgnoreCase(this.usuario);
    }

    public Set<Grupo> getGrupos() {
        return this.grupos;
    }

    public Set<Recurso> getUsuarioRecursos() {
        return this.usuarioRecursos;
    }

    public Usuario withAtivo(Boolean ativo) {
        this.setAtivo(ativo);
        return this;
    }

    public UsuarioModoAutenticacao getModoAutenticacao() {
        return this.modoAutenticacao;
    }

    public void setModoAutenticacao(UsuarioModoAutenticacao modoAutenticacao) {
        this.modoAutenticacao = modoAutenticacao;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getMatricula() {
        return this.matricula;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Rg getRg() {
        return this.rg;
    }

    public void setRg(Rg rg) {
        this.rg = rg;
    }

    public Boolean getInvalido() {
        return this.invalido;
    }

    public void setInvalido(Boolean invalido) {
        this.invalido = invalido;
    }

    public String getUsuarioOriginal() {
        return this.usuarioOriginal;
    }

    public void setUsuarioOriginal(String usuarioOriginal) {
        this.usuarioOriginal = usuarioOriginal;
    }

    public Usuario withCpf(String cpf) {
        this.cpf = cpf;
        return this;
    }

    public boolean hasToSetUsuario() {
        return this.isNew() || Objects.isNull(this.usuario);
    }

    public Long getQtdDiasSenhaExpira() {
        return this.qtdDiasSenhaExpira;
    }

    public void setQtdDiasSenhaExpira(Long qtdDiasSenhaExpira) {
        this.qtdDiasSenhaExpira = qtdDiasSenhaExpira;
    }

    public List<UsuarioHorarioAcesso> getHorariosAcesso() {
        return this.horariosAcesso;
    }

    public String getMotivoContaBloqueada() {
        return this.motivoContaBloqueada;
    }

    public void setMotivoContaBloqueada(String motivoContaBloqueada) {
        this.motivoContaBloqueada = motivoContaBloqueada;
    }

    @Generated
    public String toString() {
        return "Usuario(id=" + this.getId() + ", usuario=" + this.getUsuario() + ", nome=" + this.getNome() + ", cpf=" + this.getCpf() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Usuario)) {
            return false;
        }
        Usuario other = (Usuario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Usuario;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public UUID getIdKeycloak() {
        return this.idKeycloak;
    }

    @Generated
    public void setIdKeycloak(UUID idKeycloak) {
        this.idKeycloak = idKeycloak;
    }

    static {
        USUARIO_MODULE_CLASS.put(Arrays.asList(ModuloEnum.MODULO_RH, ModuloEnum.MODULO_TRIBUTARIO, ModuloEnum.MODULO_ESOCIAL, ModuloEnum.MODULO_UNICO, ModuloEnum.MODULO_PROCESSOJUDICIAL, ModuloEnum.MODULO_MAIS_ISS, ModuloEnum.MODULO_OBRAS, ModuloEnum.MODULO_AVALIACAO_FUNCIONAL, ModuloEnum.MODULO_SEGURANCA_TRABALHO, ModuloEnum.MODULO_OXY_FOLHA_PAGAMENTO, ModuloEnum.MODULO_RECRUTAMENTO_SELECAO), AiseUsuario.class);
        USUARIO_MODULE_CLASS.put(Arrays.asList(ModuloEnum.MODULO_CONTROLE_INTERNO, ModuloEnum.MODULO_FROTAS, ModuloEnum.MODULO_LRF, ModuloEnum.MODULO_ORCAMENTO, ModuloEnum.MODULO_SIGELO, ModuloEnum.MODULO_ALMOXARIFADO, ModuloEnum.MODULO_SISCOP, ModuloEnum.MODULO_PATRIMONIO, ModuloEnum.MODULO_PORTAL_TRANSPARENCIA, ModuloEnum.MODULO_TESOURARIA), SiscopUsuario.class);
        USUARIO_MODULE_CLASS.put(Arrays.asList(ModuloEnum.MODULO_COMPRAS), ApiceUsuario.class);
        USUARIO_MODULE_CLASS.put(Arrays.asList(ModuloEnum.MODULO_PROTOCOLO), ProtocoloUsuario.class);
    }
}

