/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.Pais;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.unico.client.dto.UfDTO;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.unidadefederacao")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class UF
extends EloDomain<Long>
implements EntityPublisher<UfDTO, Long> {
    public static final UF UF_INVALIDA = UF.of((String)"??").withId(Long.valueOf(0L)).withDescricao("CONVERSAO").withPais(Pais.PAIS_INVALIDO);
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @Length(max=2)
    @NotEmpty
    @Caption(value="Sigla")
    private @Length(max=2) @NotEmpty String sigla;
    @NotNull
    @ManyToOne
    @Caption(value="Pa\u00eds")
    private Pais pais;
    @NotNull
    @Length(max=50)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotNull @Length(max=50) String descricao;

    public static UF of(String sigla) {
        return new UF().withSigla(sigla);
    }

    private UF withPais(Pais pais) {
        this.pais = pais;
        return this;
    }

    public UF withDescricao(String descricao) {
        this.descricao = descricao;
        return this;
    }

    private UF withSigla(String sigla) {
        this.sigla = sigla;
        return this;
    }

    public UF withId(Long id) {
        this.id = id;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSigla() {
        return this.sigla;
    }

    public void setSigla(String sigla) {
        this.sigla = sigla;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Pais getPais() {
        return this.pais;
    }

    public void setPais(Pais pais) {
        this.pais = pais;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeEloEntity((EloEntity)this.getPais()) + ReplicatorFacade.hashCodeString((String)this.getSigla());
    }

    public UfDTO convertToEvent() {
        UfDTO ufDTO = new UfDTO();
        ufDTO.setSigla(this.sigla);
        ufDTO.setId(this.id);
        return ufDTO;
    }

    @Generated
    public String toString() {
        return "UF(id=" + this.getId() + ", sigla=" + this.getSigla() + ", pais=" + String.valueOf(this.getPais()) + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UF)) {
            return false;
        }
        UF other = (UF)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UF;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

