/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.unico.client.dto.TipoLogradouroDTO;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.tipologradouro")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class TipoLogradouro
extends EloDomain<Long>
implements EntityPublisher<TipoLogradouroDTO, Long> {
    public static final TipoLogradouro TIPO_LOGRADOURO_INVALIDA = TipoLogradouro.of((Long)0L).withDescricao("CONVERSAO");
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotEmpty(groups={SkipBatch.class})
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty(groups={SkipBatch.class}) @Length(max=100) String descricao;
    @Length(max=3)
    @Caption(value="Sigla")
    private @Length(max=3) String sigla;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public static TipoLogradouro of(Long codigo) {
        return new TipoLogradouro().withId(codigo);
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getSigla() {
        return this.sigla;
    }

    public void setSigla(String sigla) {
        this.sigla = sigla;
    }

    public TipoLogradouro withId(Long id) {
        this.id = id;
        return this;
    }

    public TipoLogradouro withDescricao(String descricao) {
        this.descricao = descricao;
        return this;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeString((String)this.descricao);
    }

    public TipoLogradouroDTO convertToEvent() {
        return TipoLogradouroDTO.builder().id(this.id).descricao(this.descricao).sigla(this.sigla).build();
    }

    @Generated
    public String toString() {
        return "TipoLogradouro(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", sigla=" + this.getSigla() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TipoLogradouro)) {
            return false;
        }
        TipoLogradouro other = (TipoLogradouro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TipoLogradouro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

