/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="unico.tipoleinatureza")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class TipoLeiNatureza
implements EloEntity<Long> {
    private static final Map<Long, Long> TO_SISCOP;
    public static final Long SISCOP_OUTROS;
    public static final Long SISCOP_LEI;
    public static final Long SISCOP_DECRETO;
    public static final Long SISCOP_ATO_CONSELHO;
    public static final Long SISCOP_RESOLUCAO;
    public static final Long SISCOP_PORTARIA;
    public static final Long UNICO_LEI;
    public static final Long UNICO_LEI_COMPLEMENTAR;
    public static final Long UNICO_DECRETO;
    public static final Long UNICO_ATO_CONSORCIO;
    public static final Long UNICO_RESOLUCAO;
    public static final Long UNICO_PORTARIA;
    public static final Long UNICO_INSTRUCAO;
    public static final Long UNICO_EMENDA_LEI_ORGANICA;
    public static final Long UNICO_CONSTITUICAO_ESTADUAL;
    public static final Long UNICO_LEI_ORGANICA;
    public static final Long UNICO_DECRETO_LEGISLATIVO;
    public static final Long UNICO_DECRETO_LEI;
    public static final Long UNICO_EMENDA_CONST_ESTADUAL;
    public static final Long UNICO_RN_TIPO_15;
    public static final Long UNICO_RN_TIPO_16;
    public static final Long UNICO_CONSTITUICAO_FEDERAL;
    public static final Long UNICO_EMENDA_CONST_FEDERAL;
    public static final Long UNICO_OUTROS;
    public static final Long OUTROS;
    @Id
    private Long id;
    @Caption(value="C\u00f3digo")
    private Long codigo;
    @Caption(value="Descri\u00e7\u00e3o")
    @Column(length=250)
    private String descricao;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TipoLeiNatureza withId(Long id) {
        this.setId(id);
        return this;
    }

    public static TipoLeiNatureza of(Long id) {
        return new TipoLeiNatureza().withId(id);
    }

    public TipoLeiNatureza withCodigo(Long codigo) {
        this.setCodigo(codigo);
        return this;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Long toSiscopNaturezaLeiCodigo() {
        if (TO_SISCOP.containsKey(this.codigo)) {
            return (Long)TO_SISCOP.get(this.codigo);
        }
        return SISCOP_OUTROS;
    }

    @Generated
    public String toString() {
        return "TipoLeiNatureza(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TipoLeiNatureza)) {
            return false;
        }
        TipoLeiNatureza other = (TipoLeiNatureza)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TipoLeiNatureza;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    static {
        SISCOP_OUTROS = 0L;
        SISCOP_LEI = 1L;
        SISCOP_DECRETO = 2L;
        SISCOP_ATO_CONSELHO = 3L;
        SISCOP_RESOLUCAO = 4L;
        SISCOP_PORTARIA = 5L;
        UNICO_LEI = 1L;
        UNICO_LEI_COMPLEMENTAR = 2L;
        UNICO_DECRETO = 3L;
        UNICO_ATO_CONSORCIO = 4L;
        UNICO_RESOLUCAO = 5L;
        UNICO_PORTARIA = 6L;
        UNICO_INSTRUCAO = 7L;
        UNICO_EMENDA_LEI_ORGANICA = 8L;
        UNICO_CONSTITUICAO_ESTADUAL = 9L;
        UNICO_LEI_ORGANICA = 10L;
        UNICO_DECRETO_LEGISLATIVO = 11L;
        UNICO_DECRETO_LEI = 12L;
        UNICO_EMENDA_CONST_ESTADUAL = 13L;
        UNICO_RN_TIPO_15 = 15L;
        UNICO_RN_TIPO_16 = 16L;
        UNICO_CONSTITUICAO_FEDERAL = 17L;
        UNICO_EMENDA_CONST_FEDERAL = 18L;
        UNICO_OUTROS = 99L;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)UNICO_LEI, (Object)SISCOP_LEI);
        builder.put((Object)UNICO_LEI_COMPLEMENTAR, (Object)SISCOP_LEI);
        builder.put((Object)UNICO_DECRETO, (Object)SISCOP_DECRETO);
        builder.put((Object)UNICO_ATO_CONSORCIO, (Object)SISCOP_PORTARIA);
        builder.put((Object)UNICO_RESOLUCAO, (Object)SISCOP_RESOLUCAO);
        builder.put((Object)UNICO_PORTARIA, (Object)SISCOP_PORTARIA);
        builder.put((Object)UNICO_INSTRUCAO, (Object)SISCOP_OUTROS);
        builder.put((Object)UNICO_EMENDA_LEI_ORGANICA, (Object)SISCOP_LEI);
        builder.put((Object)UNICO_CONSTITUICAO_ESTADUAL, (Object)SISCOP_LEI);
        builder.put((Object)UNICO_LEI_ORGANICA, (Object)SISCOP_LEI);
        builder.put((Object)UNICO_DECRETO_LEGISLATIVO, (Object)SISCOP_DECRETO);
        builder.put((Object)UNICO_DECRETO_LEI, (Object)SISCOP_DECRETO);
        builder.put((Object)UNICO_EMENDA_CONST_ESTADUAL, (Object)SISCOP_LEI);
        builder.put((Object)UNICO_RN_TIPO_15, (Object)SISCOP_PORTARIA);
        builder.put((Object)UNICO_RN_TIPO_16, (Object)SISCOP_PORTARIA);
        builder.put((Object)UNICO_CONSTITUICAO_FEDERAL, (Object)SISCOP_LEI);
        builder.put((Object)UNICO_EMENDA_CONST_FEDERAL, (Object)SISCOP_LEI);
        builder.put((Object)UNICO_OUTROS, (Object)SISCOP_OUTROS);
        TO_SISCOP = builder.build();
        OUTROS = 99L;
    }
}

