/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.ReportArquivo;
import br.com.elotech.di.domain.ReportJoinField;
import br.com.elotech.di.domain.query.AbstractQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Table(name="unico.report")
@Entity
@Audited
@JsonFilterFields(of={"id", "name", "filePath", "joinFields.id", "joinFields.report.id", "joinFields.parentField.id", "joinFields.parentField.caption", "joinFields.parentField.name", "joinFields.reportField.id", "joinFields.reportField.caption", "joinFields.reportField.name", "query.id", "query.name", "query.type", "query.abstractDataSource.id", "query.abstractDataSource.name", "query.abstractDataSource.type", "mainReport.id", "mainReport.name", "mainReport.filePath", "arquivos.id", "arquivos.principal", "arquivos.arquivo.id", "arquivos.arquivo.nome", "arquivos.arquivo.dataCriacao", "arquivos.arquivo.mimeType", "arquivos.arquivo.fullPath"})
public class Report
implements EloEntity<Long> {
    @Id
    @Caption(value="C\u00f3digo")
    @EloSequence(applyOnMerge=true)
    private Long id;
    @Caption(value="Nome")
    private String name;
    @OneToMany(mappedBy="report", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ReportJoinField> joinFields = new ArrayList();
    @ManyToOne(optional=false)
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @JoinColumn(name="query_id", nullable=false)
    private AbstractQuery query;
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @OneToMany(mappedBy="mainReport", cascade={CascadeType.ALL})
    private List<Report> subReport = new ArrayList();
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @JoinColumn(name="mainreport_id")
    private Report mainReport;
    @Valid
    @Caption(value="Arquivos")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="report")
    private List<ReportArquivo> arquivos = new ArrayList();

    public List<Report> getSubReport() {
        return Optional.ofNullable(this.subReport).orElse(Collections.emptyList());
    }

    @Generated
    public Report() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<ReportJoinField> getJoinFields() {
        return this.joinFields;
    }

    @Generated
    public AbstractQuery getQuery() {
        return this.query;
    }

    @Generated
    public Report getMainReport() {
        return this.mainReport;
    }

    @Generated
    public List<ReportArquivo> getArquivos() {
        return this.arquivos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setJoinFields(List<ReportJoinField> joinFields) {
        this.joinFields = joinFields;
    }

    @Generated
    public void setQuery(AbstractQuery query) {
        this.query = query;
    }

    @Generated
    public void setSubReport(List<Report> subReport) {
        this.subReport = subReport;
    }

    @Generated
    public void setMainReport(Report mainReport) {
        this.mainReport = mainReport;
    }

    @Generated
    public void setArquivos(List<ReportArquivo> arquivos) {
        this.arquivos = arquivos;
    }

    @Generated
    public String toString() {
        return "Report(id=" + this.getId() + ", name=" + this.getName() + ", joinFields=" + String.valueOf(this.getJoinFields()) + ", query=" + String.valueOf(this.getQuery()) + ", subReport=" + String.valueOf(this.getSubReport()) + ", mainReport=" + String.valueOf(this.getMainReport()) + ", arquivos=" + String.valueOf(this.getArquivos()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Report)) {
            return false;
        }
        Report other = (Report)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Report;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

